/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.gc.repository.RepositoryConnector;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Detached;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Reference;

public final class NessieRepositoryConnector
implements RepositoryConnector {
    private final NessieApiV1 api;
    static final int CONTENT_BATCH_SIZE = 250;

    private NessieRepositoryConnector(NessieApiV1 api) {
        this.api = api;
    }

    public static RepositoryConnector nessie(NessieApiV1 api) {
        return new NessieRepositoryConnector(api);
    }

    @Override
    public Stream<Reference> allReferences() throws NessieNotFoundException {
        return this.api.getAllReferences().stream();
    }

    @Override
    public Stream<LogResponse.LogEntry> commitLog(Reference ref) throws NessieNotFoundException {
        return ((GetCommitLogBuilder)this.api.getCommitLog().reference(ref)).fetch(FetchOption.ALL).stream();
    }

    @Override
    public Stream<Map.Entry<ContentKey, Content>> allContents(Detached ref, Set<Content.Type> types) {
        return StreamSupport.stream(new BatchContentSplit(ref, types), false);
    }

    @Override
    public void close() {
        this.api.close();
    }

    private class BatchContentSplit
    extends Spliterators.AbstractSpliterator<Map.Entry<ContentKey, Content>> {
        private final Detached ref;
        private final Set<Content.Type> types;
        private Iterator<ContentKey> keysSplit;
        private Iterator<Map.Entry<ContentKey, Content>> currentBatch;

        BatchContentSplit(Detached ref, Set<Content.Type> types) {
            super(Long.MAX_VALUE, 0);
            this.keysSplit = null;
            this.currentBatch = Collections.emptyIterator();
            this.ref = ref;
            this.types = types;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<ContentKey, Content>> action) {
            if (this.keysSplit == null) {
                try {
                    this.keysSplit = this.allContentKeys(this.ref, this.types).iterator();
                }
                catch (NessieNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            while (true) {
                if (this.currentBatch.hasNext()) {
                    action.accept(this.currentBatch.next());
                    return true;
                }
                ArrayList<ContentKey> batchKeys = new ArrayList<ContentKey>();
                while (batchKeys.size() < 250 && this.keysSplit.hasNext()) {
                    batchKeys.add(this.keysSplit.next());
                }
                if (batchKeys.isEmpty()) {
                    return false;
                }
                try {
                    this.currentBatch = this.fetchContents(this.ref, batchKeys).entrySet().iterator();
                }
                catch (NessieNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private Map<ContentKey, Content> fetchContents(Detached ref, List<ContentKey> allKeys) throws NessieNotFoundException {
            return ((GetContentBuilder)NessieRepositoryConnector.this.api.getContent().reference((Reference)ref)).keys(allKeys).get();
        }

        private Stream<ContentKey> allContentKeys(Detached ref, Set<Content.Type> types) throws NessieNotFoundException {
            return ((GetEntriesBuilder)NessieRepositoryConnector.this.api.getEntries().reference((Reference)ref)).stream().filter(e -> types.contains(e.getType())).map(EntriesResponse.Entry::getName);
        }
    }
}

