/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.expire.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.gc.expire.Expire;
import org.projectnessie.gc.expire.ExpireParameters;
import org.projectnessie.gc.expire.PerContentDeleteExpired;
import org.projectnessie.gc.expire.local.ImmutableDefaultLocalExpire;
import org.projectnessie.gc.files.DeleteSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class DefaultLocalExpire
implements Expire {
    public static final int DEFAULT_PARALLELISM = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalExpire.class);

    public static Builder builder() {
        return ImmutableDefaultLocalExpire.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSummary expire() {
        LOGGER.info("live-set#{}: Starting expiry.", (Object)this.expireParameters().liveContentSet().id());
        Instant started = this.clock().instant();
        this.expireParameters().liveContentSet().startExpireContents(started);
        ForkJoinPool forkJoinPool = new ForkJoinPool(this.parallelism());
        try {
            DeleteSummary deleteSummary = forkJoinPool.invoke(ForkJoinTask.adapt(this::expireInForkJoinPool));
            LOGGER.info("live-set#{}: Expiry finished, took {}, deletion summary: {}.", new Object[]{this.expireParameters().liveContentSet().id(), Duration.between(started, this.clock().instant()), deleteSummary});
            DeleteSummary deleteSummary2 = deleteSummary;
            return deleteSummary2;
        }
        finally {
            this.expireParameters().liveContentSet().finishedExpireContents(this.clock().instant(), null);
            forkJoinPool.shutdown();
        }
    }

    private DeleteSummary expireInForkJoinPool() {
        try (Stream<String> contentIds = this.expireParameters().liveContentSet().fetchContentIds();){
            DeleteSummary deleteSummary = ((Stream)contentIds.parallel()).map(this::expireSingleContent).reduce(DeleteSummary.EMPTY, DeleteSummary::add);
            return deleteSummary;
        }
    }

    private DeleteSummary expireSingleContent(String contentId) {
        LOGGER.debug("live-set#{}: Expiring content ID {}.", (Object)this.expireParameters().liveContentSet().id(), (Object)contentId);
        return PerContentDeleteExpired.builder().expireParameters(this.expireParameters()).contentId(contentId).build().expire();
    }

    abstract ExpireParameters expireParameters();

    @Value.Default
    int parallelism() {
        return 4;
    }

    @Value.Default
    @VisibleForTesting
    Clock clock() {
        return Clock.systemUTC();
    }

    @Value.Check
    void verify() {
        Preconditions.checkArgument((this.parallelism() >= 1 ? 1 : 0) != 0, (Object)"Parallelism must be greater than 0");
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder expireParameters(ExpireParameters var1);

        @CanIgnoreReturnValue
        public Builder parallelism(int var1);

        public DefaultLocalExpire build();
    }
}

