/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.identify;

import java.time.Instant;
import javax.annotation.Nonnull;
import org.projectnessie.gc.identify.NoneCutoffPolicy;
import org.projectnessie.gc.identify.NumCommitsCutoffPolicy;
import org.projectnessie.gc.identify.TimestampCutoffPolicy;

@FunctionalInterface
public interface CutoffPolicy {
    public static final Instant NO_TIMESTAMP = Instant.MAX;
    public static final CutoffPolicy NONE = new NoneCutoffPolicy();

    default public Instant timestamp() {
        return NO_TIMESTAMP;
    }

    public boolean isCutoff(@Nonnull Instant var1, int var2);

    public static CutoffPolicy atTimestamp(@Nonnull Instant cutoffTimestamp) {
        return new TimestampCutoffPolicy(cutoffTimestamp);
    }

    public static CutoffPolicy numCommits(int commits) {
        return new NumCommitsCutoffPolicy(commits);
    }
}

