/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.MustBeClosed;
import java.time.Clock;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.gc.contents.AddContents;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.gc.contents.ImmutableLiveContentSetsRepository;
import org.projectnessie.gc.contents.LiveContentSet;
import org.projectnessie.gc.contents.LiveContentSetNotFoundException;
import org.projectnessie.gc.contents.spi.PersistenceSpi;

@Value.Immutable
public abstract class LiveContentSetsRepository {
    public static Builder builder() {
        return ImmutableLiveContentSetsRepository.builder();
    }

    public LiveContentSet getLiveContentSet(UUID id) throws LiveContentSetNotFoundException {
        return this.persistenceSpi().getLiveContentSet(id);
    }

    @MustBeClosed
    public Stream<LiveContentSet> getAllLiveContents() {
        return this.persistenceSpi().getAllLiveContents();
    }

    @MustBeClosed
    public AddContents newAddContents() {
        return new AddContents(){
            private final UUID id;
            private final Instant created;
            private volatile boolean closed;
            private boolean finished;
            private Throwable failure;
            {
                this.id = LiveContentSetsRepository.this.idGenerator().get();
                this.created = LiveContentSetsRepository.this.clock().instant();
                LiveContentSetsRepository.this.persistenceSpi().startIdentifyLiveContents(this.id, this.created);
            }

            @Override
            public UUID id() {
                return this.id;
            }

            @Override
            public Instant created() {
                return this.created;
            }

            @Override
            public void finished() {
                Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"AddContents instance is already in finished state.");
                this.finished = true;
            }

            @Override
            public void finishedExceptionally(@NotNull Throwable e) {
                if (this.failure == null) {
                    this.failure = e;
                } else {
                    this.failure.addSuppressed(e);
                }
                this.finished = true;
            }

            @Override
            public long addLiveContent(@NotNull Stream<ContentReference> contentReference) {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"AddContents instance already closed.");
                return LiveContentSetsRepository.this.persistenceSpi().addIdentifiedLiveContent(this.id, contentReference);
            }

            @Override
            public void close() {
                if (!this.finished) {
                    this.failure = new IllegalStateException("AddContents instance has not been finished.");
                }
                if (this.closed) {
                    return;
                }
                this.closed = true;
                LiveContentSetsRepository.this.persistenceSpi().finishedIdentifyLiveContents(this.id, LiveContentSetsRepository.this.clock().instant(), this.failure);
            }
        };
    }

    abstract PersistenceSpi persistenceSpi();

    @Value.Default
    @VisibleForTesting
    Clock clock() {
        return Clock.systemUTC();
    }

    @Value.Default
    @VisibleForTesting
    Supplier<UUID> idGenerator() {
        return UUID::randomUUID;
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder persistenceSpi(PersistenceSpi var1);

        public LiveContentSetsRepository build();
    }
}

