/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.expire;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import org.immutables.value.Value;
import org.projectnessie.gc.contents.LiveContentSet;
import org.projectnessie.gc.expire.ContentToFiles;
import org.projectnessie.gc.expire.ImmutableExpireParameters;
import org.projectnessie.gc.files.FileDeleter;
import org.projectnessie.gc.files.FilesLister;

@Value.Immutable
public interface ExpireParameters {
    public static final long DEFAULT_EXPECTED_FILE_COUNT = 1000000L;
    public static final double DEFAULT_FALSE_POSITIVE_PROBABILITY = 1.0E-5;
    public static final double DEFAULT_ALLOWED_FALSE_POSITIVE_PROBABILITY = 1.0E-4;

    public static Builder builder() {
        return ImmutableExpireParameters.builder();
    }

    @Value.Default
    default public long expectedFileCount() {
        return 1000000L;
    }

    @Value.Default
    default public double falsePositiveProbability() {
        return 1.0E-5;
    }

    @Value.Default
    default public double allowedFalsePositiveProbability() {
        return 1.0E-4;
    }

    public FilesLister filesLister();

    public ContentToFiles contentToFiles();

    public LiveContentSet liveContentSet();

    public Instant maxFileModificationTime();

    public FileDeleter fileDeleter();

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder expectedFileCount(long var1);

        @CanIgnoreReturnValue
        public Builder falsePositiveProbability(double var1);

        @CanIgnoreReturnValue
        public Builder allowedFalsePositiveProbability(double var1);

        @CanIgnoreReturnValue
        public Builder filesLister(FilesLister var1);

        @CanIgnoreReturnValue
        public Builder contentToFiles(ContentToFiles var1);

        @CanIgnoreReturnValue
        public Builder liveContentSet(LiveContentSet var1);

        @CanIgnoreReturnValue
        public Builder maxFileModificationTime(Instant var1);

        @CanIgnoreReturnValue
        public Builder fileDeleter(FileDeleter var1);

        public ExpireParameters build();
    }
}

