/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentReference", generator="Immutables")
@Immutable
public final class ImmutableContentReference
implements ContentReference {
    private final String contentId;
    private final String commitId;
    private final ContentKey contentKey;
    private final Content.Type contentType;
    @jakarta.annotation.Nullable
    private final String metadataLocation;
    @jakarta.annotation.Nullable
    private final Long snapshotId;

    private ImmutableContentReference(String contentId, String commitId, ContentKey contentKey, Content.Type contentType, @jakarta.annotation.Nullable String metadataLocation, @jakarta.annotation.Nullable Long snapshotId) {
        this.contentId = Objects.requireNonNull(contentId, "contentId");
        this.commitId = Objects.requireNonNull(commitId, "commitId");
        this.contentKey = Objects.requireNonNull(contentKey, "contentKey");
        this.contentType = Objects.requireNonNull(contentType, "contentType");
        this.metadataLocation = metadataLocation;
        this.snapshotId = snapshotId;
    }

    private ImmutableContentReference(ImmutableContentReference original, String contentId, String commitId, ContentKey contentKey, Content.Type contentType, @jakarta.annotation.Nullable String metadataLocation, @jakarta.annotation.Nullable Long snapshotId) {
        this.contentId = contentId;
        this.commitId = commitId;
        this.contentKey = contentKey;
        this.contentType = contentType;
        this.metadataLocation = metadataLocation;
        this.snapshotId = snapshotId;
    }

    @Override
    public String contentId() {
        return this.contentId;
    }

    @Override
    public String commitId() {
        return this.commitId;
    }

    @Override
    public ContentKey contentKey() {
        return this.contentKey;
    }

    @Override
    public Content.Type contentType() {
        return this.contentType;
    }

    @Override
    @jakarta.annotation.Nullable
    public String metadataLocation() {
        return this.metadataLocation;
    }

    @Override
    @jakarta.annotation.Nullable
    public Long snapshotId() {
        return this.snapshotId;
    }

    public final ImmutableContentReference withContentId(String value) {
        String newValue = Objects.requireNonNull(value, "contentId");
        if (this.contentId.equals(newValue)) {
            return this;
        }
        return new ImmutableContentReference(this, newValue, this.commitId, this.contentKey, this.contentType, this.metadataLocation, this.snapshotId);
    }

    public final ImmutableContentReference withCommitId(String value) {
        String newValue = Objects.requireNonNull(value, "commitId");
        if (this.commitId.equals(newValue)) {
            return this;
        }
        return new ImmutableContentReference(this, this.contentId, newValue, this.contentKey, this.contentType, this.metadataLocation, this.snapshotId);
    }

    public final ImmutableContentReference withContentKey(ContentKey value) {
        if (this.contentKey == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "contentKey");
        return new ImmutableContentReference(this, this.contentId, this.commitId, newValue, this.contentType, this.metadataLocation, this.snapshotId);
    }

    public final ImmutableContentReference withContentType(Content.Type value) {
        if (this.contentType == value) {
            return this;
        }
        Content.Type newValue = Objects.requireNonNull(value, "contentType");
        return new ImmutableContentReference(this, this.contentId, this.commitId, this.contentKey, newValue, this.metadataLocation, this.snapshotId);
    }

    public final ImmutableContentReference withMetadataLocation(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.metadataLocation, value)) {
            return this;
        }
        return new ImmutableContentReference(this, this.contentId, this.commitId, this.contentKey, this.contentType, value, this.snapshotId);
    }

    public final ImmutableContentReference withSnapshotId(@jakarta.annotation.Nullable Long value) {
        if (Objects.equals(this.snapshotId, value)) {
            return this;
        }
        return new ImmutableContentReference(this, this.contentId, this.commitId, this.contentKey, this.contentType, this.metadataLocation, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentReference && this.equalTo(0, (ImmutableContentReference)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentReference another) {
        return this.contentId.equals(another.contentId) && this.contentType.equals(another.contentType) && Objects.equals(this.metadataLocation, another.metadataLocation) && Objects.equals(this.snapshotId, another.snapshotId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + this.contentType.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadataLocation);
        h += (h << 5) + Objects.hashCode(this.snapshotId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentReference").omitNullValues().add("contentId", (Object)this.contentId).add("contentType", (Object)this.contentType).add("metadataLocation", (Object)this.metadataLocation).add("snapshotId", (Object)this.snapshotId).toString();
    }

    public static ImmutableContentReference of(String contentId, String commitId, ContentKey contentKey, Content.Type contentType, @jakarta.annotation.Nullable String metadataLocation, @jakarta.annotation.Nullable Long snapshotId) {
        return new ImmutableContentReference(contentId, commitId, contentKey, contentType, metadataLocation, snapshotId);
    }

    public static ImmutableContentReference copyOf(ContentReference instance) {
        if (instance instanceof ImmutableContentReference) {
            return (ImmutableContentReference)instance;
        }
        return ImmutableContentReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_ID = 1L;
        private static final long INIT_BIT_COMMIT_ID = 2L;
        private static final long INIT_BIT_CONTENT_KEY = 4L;
        private static final long INIT_BIT_CONTENT_TYPE = 8L;
        private long initBits = 15L;
        @Nullable
        private String contentId;
        @Nullable
        private String commitId;
        @Nullable
        private ContentKey contentKey;
        @Nullable
        private Content.Type contentType;
        @Nullable
        private String metadataLocation;
        @Nullable
        private Long snapshotId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentReference instance) {
            Long snapshotIdValue;
            Objects.requireNonNull(instance, "instance");
            this.contentId(instance.contentId());
            this.commitId(instance.commitId());
            this.contentKey(instance.contentKey());
            this.contentType(instance.contentType());
            String metadataLocationValue = instance.metadataLocation();
            if (metadataLocationValue != null) {
                this.metadataLocation(metadataLocationValue);
            }
            if ((snapshotIdValue = instance.snapshotId()) != null) {
                this.snapshotId(snapshotIdValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(String contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitId(String commitId) {
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKey(ContentKey contentKey) {
            this.contentKey = Objects.requireNonNull(contentKey, "contentKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(Content.Type contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadataLocation(@jakarta.annotation.Nullable String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(@jakarta.annotation.Nullable Long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public ImmutableContentReference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentReference(null, this.contentId, this.commitId, this.contentKey, this.contentType, this.metadataLocation, this.snapshotId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("contentKey");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("contentType");
            }
            return "Cannot build ContentReference, some of required attributes are not set " + attributes;
        }
    }
}

