/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents;

import com.google.errorprone.annotations.MustBeClosed;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.gc.contents.ImmutableLiveContentSet;
import org.projectnessie.gc.contents.spi.PersistenceSpi;
import org.projectnessie.gc.files.DeleteResult;
import org.projectnessie.gc.files.DeleteSummary;
import org.projectnessie.gc.files.FileDeleter;
import org.projectnessie.gc.files.FileReference;

@Value.Immutable
public abstract class LiveContentSet {
    public static ImmutableLiveContentSet.Builder builder() {
        return ImmutableLiveContentSet.builder();
    }

    public ImmutableLiveContentSet.Builder unbuild() {
        return ImmutableLiveContentSet.builder().from(this);
    }

    abstract PersistenceSpi persistenceSpi();

    public abstract UUID id();

    public abstract Instant created();

    @javax.annotation.Nullable
    @Nullable
    public abstract Instant identifyCompleted();

    @javax.annotation.Nullable
    @Nullable
    public abstract Instant expiryStarted();

    @javax.annotation.Nullable
    @Nullable
    public abstract Instant expiryCompleted();

    public abstract Status status();

    @javax.annotation.Nullable
    @Nullable
    public abstract String errorMessage();

    public void delete() {
        this.persistenceSpi().deleteLiveContentSet(this.id());
    }

    public long fetchDistinctContentIdCount() {
        return this.persistenceSpi().fetchDistinctContentIdCount(this.id());
    }

    @MustBeClosed
    public Stream<String> fetchContentIds() {
        return this.persistenceSpi().fetchContentIds(this.id());
    }

    @MustBeClosed
    public Stream<ContentReference> fetchContentReferences(@NotNull @jakarta.validation.constraints.NotNull String contentId) {
        return this.persistenceSpi().fetchContentReferences(this.id(), contentId);
    }

    public void associateBaseLocations(String contentId, Collection<URI> baseLocations) {
        this.persistenceSpi().associateBaseLocations(this.id(), contentId, baseLocations);
    }

    @MustBeClosed
    public Stream<URI> fetchAllBaseLocations() {
        return this.persistenceSpi().fetchAllBaseLocations(this.id());
    }

    @MustBeClosed
    public Stream<URI> fetchBaseLocations(@NotNull @jakarta.validation.constraints.NotNull String contentId) {
        return this.persistenceSpi().fetchBaseLocations(this.id(), contentId);
    }

    public LiveContentSet startExpireContents(@NotNull @jakarta.validation.constraints.NotNull Instant started) {
        return this.persistenceSpi().startExpireContents(this.id(), started);
    }

    public LiveContentSet finishedExpireContents(@NotNull @jakarta.validation.constraints.NotNull Instant finished, @javax.annotation.Nullable @Nullable Throwable failure) {
        return this.persistenceSpi().finishedExpireContents(this.id(), finished, failure);
    }

    public long addFileDeletions(Stream<FileReference> files) {
        return this.persistenceSpi().addFileDeletions(this.id(), files);
    }

    @MustBeClosed
    public Stream<FileReference> fetchFileDeletions() {
        return this.persistenceSpi().fetchFileDeletions(this.id());
    }

    public FileDeleter fileDeleter() {
        return new FileDeleter(){

            @Override
            public DeleteResult delete(FileReference fileReference) {
                LiveContentSet.this.addFileDeletions(Stream.of(fileReference));
                return DeleteResult.SUCCESS;
            }

            @Override
            public DeleteSummary deleteMultiple(URI baseUri, Stream<FileReference> fileObjects) {
                long count = LiveContentSet.this.addFileDeletions(fileObjects);
                return DeleteSummary.of(count, 0L);
            }
        };
    }

    public static enum Status {
        IDENTIFY_IN_PROGRESS,
        IDENTIFY_SUCCESS,
        IDENTIFY_FAILED,
        EXPIRY_IN_PROGRESS,
        EXPIRY_SUCCESS,
        EXPIRY_FAILED;

    }
}

