/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.files;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.files.DeleteSummary;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeleteSummary", generator="Immutables")
@Immutable
public final class ImmutableDeleteSummary
implements DeleteSummary {
    private final long deleted;
    private final long failures;

    private ImmutableDeleteSummary(long deleted, long failures) {
        this.deleted = deleted;
        this.failures = failures;
    }

    private ImmutableDeleteSummary(ImmutableDeleteSummary original, long deleted, long failures) {
        this.deleted = deleted;
        this.failures = failures;
    }

    @Override
    public long deleted() {
        return this.deleted;
    }

    @Override
    public long failures() {
        return this.failures;
    }

    public final ImmutableDeleteSummary withDeleted(long value) {
        if (this.deleted == value) {
            return this;
        }
        return new ImmutableDeleteSummary(this, value, this.failures);
    }

    public final ImmutableDeleteSummary withFailures(long value) {
        if (this.failures == value) {
            return this;
        }
        return new ImmutableDeleteSummary(this, this.deleted, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteSummary && this.equalTo(0, (ImmutableDeleteSummary)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteSummary another) {
        return this.deleted == another.deleted && this.failures == another.failures;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.deleted);
        h += (h << 5) + Longs.hashCode((long)this.failures);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeleteSummary").omitNullValues().add("deleted", this.deleted).add("failures", this.failures).toString();
    }

    public static ImmutableDeleteSummary of(long deleted, long failures) {
        return new ImmutableDeleteSummary(deleted, failures);
    }

    public static ImmutableDeleteSummary copyOf(DeleteSummary instance) {
        if (instance instanceof ImmutableDeleteSummary) {
            return (ImmutableDeleteSummary)instance;
        }
        return ImmutableDeleteSummary.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteSummary", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DELETED = 1L;
        private static final long INIT_BIT_FAILURES = 2L;
        private long initBits = 3L;
        private long deleted;
        private long failures;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeleteSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.deleted(instance.deleted());
            this.failures(instance.failures());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deleted(long deleted) {
            this.deleted = deleted;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder failures(long failures) {
            this.failures = failures;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDeleteSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteSummary(null, this.deleted, this.failures);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deleted");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("failures");
            }
            return "Cannot build DeleteSummary, some of required attributes are not set " + attributes;
        }
    }
}

