/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.identify;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;
import org.projectnessie.gc.identify.CutoffPolicy;

final class TimestampCutoffPolicy
implements CutoffPolicy {
    private final Instant cutoffTimestamp;

    TimestampCutoffPolicy(Instant cutoffTimestamp) {
        this.cutoffTimestamp = cutoffTimestamp;
    }

    @Override
    public boolean isCutoff(@javax.annotation.Nonnull @Nonnull Instant commitTime, int numCommits) {
        return (long)commitTime.compareTo(this.cutoffTimestamp) < 0L;
    }

    public String toString() {
        return "cutoff at timestamp " + this.cutoffTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimestampCutoffPolicy)) {
            return false;
        }
        TimestampCutoffPolicy that = (TimestampCutoffPolicy)o;
        return this.cutoffTimestamp.equals(that.cutoffTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.cutoffTimestamp);
    }
}

