/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.hms.BaseHiveOps;
import com.klarna.hiverunner.HiveRunnerExtension;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;

@ExtendWith(value={HiveRunnerExtension.class})
public abstract class BaseTableOperations
extends BaseHiveOps {
    @Test
    public void invalidTypes() {
        BaseTableOperations.assertThrows("immutable=true", Exception.class, () -> this.shell.execute("create external table t2 (a int, b int) PARTITIONED BY (c int);"));
        BaseTableOperations.assertThrows("External Tables", Exception.class, () -> this.shell.execute("create table t2 (a int, b int) PARTITIONED BY (c int);"));
    }

    @Test
    public void insertOnImmutable() {
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        this.shell.execute("insert into t1 PARTITION(c)select 1 as a,1 as b,1 as c union all select 2,2,2 union all select 3,3,3 union all select 4,4,4 ");
        List partitions = this.shell.executeQuery("show partitions t1");
        MatcherAssert.assertThat((Object)partitions, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"c=1", "c=2", "c=3", "c=4"}));
        this.shell.execute("alter table t1 drop partition (c=1)");
        List partitions2 = this.shell.executeQuery("show partitions t1");
        MatcherAssert.assertThat((Object)partitions2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"c=2", "c=3", "c=4"}));
        this.shell.execute("drop table t1");
    }

    @Test
    public void changeContext() throws NessieNotFoundException, NessieConflictException {
        String mainOriginalHash = client.getTreeApi().getDefaultBranch().getHash();
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        this.shell.execute("insert into t1 PARTITION(c) select 1 as a,1 as b,1 as c union all select 2,2,2 union all select 3,3,3 union all select 4,4,4 ");
        this.shell.execute(String.format("CREATE VIEW `$nessie`.dev TBLPROPERTIES(\"ref\"=\"%s\") AS SELECT * FROM T1", mainOriginalHash));
        this.shell.execute("alter database `$nessie` set dbproperties (\"ref\"=\"dev\")");
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        Assertions.assertEquals((int)0, (int)this.shell.executeQuery("select * from `t1`").size());
        Assertions.assertEquals((int)4, (int)this.shell.executeQuery("select * from `t1@main`").size());
        this.shell.execute("alter database `$nessie` set dbproperties (\"ref\"=\"main\")");
        Assertions.assertEquals((int)4, (int)this.shell.executeQuery("select * from `t1`").size());
        Assertions.assertEquals((int)0, (int)this.shell.executeQuery("select * from `t1@dev`").size());
        this.shell.execute("drop table t1");
        this.shell.execute("alter database `$nessie` set dbproperties (\"ref\"=\"dev\")");
        this.shell.execute("drop table t1");
        Object[] items = this.shell.executeQuery("show tables in `$nessie`").toArray();
        MatcherAssert.assertThat(Arrays.asList("main", "dev"), (Matcher)Matchers.containsInAnyOrder((Object[])items));
    }

    @Test
    public void tableCreateDrop() {
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        List records = this.shell.executeStatement("describe t1");
        this.shell.execute("DROP TABLE t1");
    }

    private static <T extends Throwable> T assertThrows(String expectedMessageFragment, Class<T> clazz, Executable e) {
        Throwable ex = Assertions.assertThrows(clazz, (Executable)e);
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)expectedMessageFragment));
        return (T)ex;
    }
}

