/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;

@Consumes(value={"application/json"})
@Path(value="contents")
public interface ContentsApi {
    @GET
    @Produces(value={"application/json"})
    @Path(value="{key}")
    @Operation(summary="Get object content associated with key")
    @APIResponses(value={@APIResponse(responseCode="200", description="Information for table"), @APIResponse(responseCode="404", description="Table not found on ref")})
    public Contents getContents(@Valid @Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") @Parameter(description="Reference to use. Defaults to default branch if not provided.") @QueryParam(value="ref") @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") String var2) throws NessieNotFoundException;

    @POST
    @Consumes(value={"application/json"})
    @Operation(summary="Get multiple objects' content")
    @APIResponses(value={@APIResponse(responseCode="200", description="Retrieved successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists")})
    public MultiGetContentsResponse getMultipleContents(@Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") @Parameter(description="Reference to use. Defaults to default branch if not provided.") @QueryParam(value="ref") @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") String var1, @Valid @NotNull @RequestBody(description="Keys to retrieve.") MultiGetContentsRequest var2) throws NessieNotFoundException;

    @POST
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Operation(summary="Update object content associated with key")
    @APIResponses(value={@APIResponse(responseCode="204", description="Contents updated successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Update conflict")})
    public void setContents(@Valid @NotNull @Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Branch to change. Defaults to default branch.") @QueryParam(value="branch") @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var2, @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @NotNull @Parameter(description="Expected hash of branch.") @QueryParam(value="hash") @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @NotNull String var3, @Parameter(description="Commit message") @QueryParam(value="message") String var4, @Valid @NotNull @RequestBody(description="Contents to be upserted") Contents var5) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="{key}")
    @Operation(summary="Delete object content associated with key")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Delete conflict")})
    public void deleteContents(@Valid @Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Branch to delete from. Defaults to default branch.") @QueryParam(value="branch") @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var2, @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected hash of branch.") @QueryParam(value="hash") @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var3, @Parameter(description="Commit message") @QueryParam(value="message") String var4) throws NessieNotFoundException, NessieConflictException;
}

