/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpUtils;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;

public class HttpClient {
    private final URI baseUri;
    private final String accept;
    private final ObjectMapper mapper;
    private final SSLContext sslContext;
    private final List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
    private final List<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();

    private HttpClient(URI baseUri, String accept, ObjectMapper mapper, SSLContext sslContext) {
        this.baseUri = Objects.requireNonNull(baseUri);
        this.accept = HttpUtils.checkNonNullTrim(accept);
        this.mapper = mapper;
        this.sslContext = sslContext;
        if (!"http".equals(baseUri.getScheme()) && !"https".equals(baseUri.getScheme())) {
            throw new IllegalArgumentException(String.format("Cannot start http client. %s must be a valid http or https address", baseUri));
        }
    }

    public void register(RequestFilter filter) {
        this.requestFilters.add(filter);
    }

    public void register(ResponseFilter filter) {
        this.responseFilters.add(filter);
    }

    public HttpRequest newRequest() {
        return new HttpRequest(this.baseUri, this.accept, this.mapper, this.requestFilters, this.responseFilters, this.sslContext);
    }

    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    /* synthetic */ HttpClient(URI uRI, String string, ObjectMapper objectMapper, SSLContext sSLContext, HttpClient httpClient) {
        this(uRI, string, objectMapper, sSLContext);
    }

    public static class HttpClientBuilder {
        private URI baseUri;
        private String accept = "application/json";
        private ObjectMapper mapper;
        private SSLContext sslContext;

        private HttpClientBuilder() {
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public HttpClientBuilder setBaseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public String getAccept() {
            return this.accept;
        }

        public HttpClientBuilder setAccept(String accept) {
            this.accept = accept;
            return this;
        }

        public ObjectMapper getMapper() {
            return this.mapper;
        }

        public HttpClientBuilder setObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public HttpClientBuilder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public HttpClient build() {
            HttpUtils.checkArgument(this.baseUri != null, "Cannot construct Http client. Must have a non-null uri", new Object[0]);
            HttpUtils.checkArgument(this.accept != null, "Cannot construct Http client. Must have a non-null accept string", new Object[0]);
            HttpUtils.checkArgument(this.mapper != null, "Cannot construct Http client. Must have a non-null object mapper", new Object[0]);
            if (this.sslContext == null) {
                try {
                    this.sslContext = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new HttpClientException("Cannot construct Http Client. Default SSL config is invalid.", e);
                }
            }
            return new HttpClient(this.baseUri, this.accept, this.mapper, this.sslContext, null);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

