package org.projectnessie;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.FileMetadataHandler;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.projectnessie.hms.BaseRawStore;
import org.projectnessie.hms.Empties;

public class Hive2NessieRawStore extends BaseRawStore {
  public Hive2NessieRawStore() {
    super(false);
  }

  public Hive2NessieRawStore(boolean delegate) {
    super(delegate);
  }

  @Override
  public Table getTable(String dbName, String tableName) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTable(dbName, tableName);
    } else {
      return nessie.getTable(dbName, tableName);
    }
  }

  @Override
  public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys,
      List<SQLForeignKey> foreignKeys) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(tbl))) {
      delegate.createTableWithConstraints(tbl, primaryKeys, foreignKeys);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName,
      List<String> partVals, String colName) throws NoSuchObjectException, MetaException,
      InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.deletePartitionColumnStatistics(dbName, tableName, partName, partVals, colName);
    } else {
      return true;
    }
  }

  @Override
  public boolean isPartitionMarkedForEvent(String dbName, String tblName,
      Map<String, String> partName, PartitionEventType evtType) throws MetaException,
      UnknownTableException, InvalidPartitionException, UnknownPartitionException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.isPartitionMarkedForEvent(dbName, tblName, partName, evtType);
    } else {
      return true;
    }
  }

  @Override
  public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws
      NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.deleteTableColumnStatistics(dbName, tableName, colName);
    } else {
      return true;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPartitionGrantsAll(String dbName, String tableName,
      String partitionName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listPartitionGrantsAll(dbName, tableName, partitionName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public PrincipalPrivilegeSet getPartitionPrivilegeSet(String dbName, String tableName,
      String partition, String userName, List<String> groupNames) throws InvalidObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionPrivilegeSet(dbName, tableName, partition, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public Table markPartitionForEvent(String dbName, String tblName, Map<String, String> partVals,
      PartitionEventType evtType) throws MetaException, UnknownTableException,
      InvalidPartitionException, UnknownPartitionException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      return delegate.markPartitionForEvent(dbName, tblName, partVals, evtType);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<Partition> getPartitions(String dbName, String tableName, int max) throws
      MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitions(dbName, tableName, max);
    } else {
      return nessie.getPartitions(dbName, tableName, max);
    }
  }

  @Override
  public void alterPartitions(String db_name, String tbl_name, List<List<String>> part_vals_list,
      List<Partition> new_parts) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      delegate.alterPartitions(db_name, tbl_name, part_vals_list, new_parts);
    } else {
      nessie.alterPartitions(db_name, tbl_name, part_vals_list, new_parts);
    }
  }

  @Override
  public List<ColumnStatistics> getPartitionColumnStatistics(String dbName, String tblName,
      List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionColumnStatistics(dbName, tblName, partNames, colNames);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public void dropFunction(String dbName, String funcName) throws MetaException,
      NoSuchObjectException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      delegate.dropFunction(dbName, funcName);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String dbName, String tableName,
      String partitionName, String columnName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listPartitionColumnGrantsAll(dbName, tableName, partitionName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public void alterFunction(String dbName, String funcName, Function newFunction) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      delegate.alterFunction(dbName, funcName, newFunction);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public AggrStats get_aggr_stats_for(String dbName, String tblName, List<String> partNames,
      List<String> colNames) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      return delegate.get_aggr_stats_for(dbName, tblName, partNames, colNames);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public FileMetadataHandler getFileMetadataHandler(FileMetadataExprType type) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getFileMetadataHandler(type);
  }

  @Override
  public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata,
      FileMetadataExprType type) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.putFileMetadata(fileIds, metadata, type);
  }

  @Override
  public List<SQLForeignKey> getForeignKeys(String parent_db_name, String parent_tbl_name,
      String foreign_db_name, String foreign_tbl_name) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(parent_db_name))) {
      return delegate.getForeignKeys(parent_db_name, parent_tbl_name, foreign_db_name, foreign_tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<SQLPrimaryKey> getPrimaryKeys(String db_name, String tbl_name) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.getPrimaryKeys(db_name, tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public void dropConstraint(String dbName, String tableName, String constraintName) throws
      NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      delegate.dropConstraint(dbName, tableName, constraintName);
    } else {
      return;
    }
  }

  @Override
  public void alterIndex(String dbname, String baseTblName, String name, Index newIndex) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbname))) {
      delegate.alterIndex(dbname, baseTblName, name, newIndex);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalDBGrants(String principalName,
      PrincipalType principalType, String dbName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalDBGrants(principalName, principalType, dbName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String principalName,
      PrincipalType principalType, String dbName, String tableName, List<String> partValues,
      String partName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalPartitionGrants(principalName, principalType, dbName, tableName, partValues, partName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalDBGrantsAll(principalName, principalType);
  }

  @Override
  public boolean grantRole(Role role, String userName, PrincipalType principalType, String grantor,
      PrincipalType grantorType, boolean grantOption) throws MetaException, NoSuchObjectException,
      InvalidObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.grantRole(role, userName, principalType, grantor, grantorType, grantOption);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalPartitionGrantsAll(principalName, principalType);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalTableColumnGrantsAll(principalName, principalType);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalPartitionColumnGrantsAll(principalName, principalType);
  }

  @Override
  public void verifySchema() throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.verifySchema();
    } else {
      return;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalGlobalGrants(principalName, principalType);
  }

  @Override
  public List<Role> listRoles(String principalName, PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listRoles(principalName, principalType);
  }

  @Override
  public int addMasterKey(String key) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.addMasterKey(key);
  }

  @Override
  public boolean removeRole(String roleName) throws MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.removeRole(roleName);
  }

  @Override
  public void cleanNotificationEvents(int olderThan) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.cleanNotificationEvents(olderThan);
    } else {
      return;
    }
  }

  @Override
  public void flushCache() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.flushCache();
    } else {
      return;
    }
  }

  @Override
  public boolean updateTableColumnStatistics(ColumnStatistics colStats) throws
      NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.updateTableColumnStatistics(colStats);
    } else {
      return true;
    }
  }

  @Override
  public boolean isFileMetadataSupported() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.isFileMetadataSupported();
    } else {
      return true;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listGlobalGrantsAll() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listGlobalGrantsAll();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getNextNotification(rqst);
    } else {
      return Empties.event();
    }
  }

  @Override
  public List<String> listRoleNames() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listRoleNames();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public boolean addRole(String rowName, String ownerName) throws InvalidObjectException,
      MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.addRole(rowName, ownerName);
    } else {
      return true;
    }
  }

  @Override
  public Role getRole(String roleName) throws NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getRole(roleName);
  }

  @Override
  public void addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(fks.stream().flatMap(BaseRawStore::route))) {
      delegate.addForeignKeys(fks);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public void addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(pks.stream().flatMap(BaseRawStore::route))) {
      delegate.addPrimaryKeys(pks);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public boolean dropType(String typeName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.dropType(typeName);
  }

  @Override
  public String[] getMasterKeys() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getMasterKeys();
    } else {
      return new String[0];
    }
  }

  @Override
  public void getFileMetadataByExpr(List<Long> fileIds, FileMetadataExprType type, byte[] expr,
      ByteBuffer[] metadatas, ByteBuffer[] exprResults, boolean[] eliminated) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.getFileMetadataByExpr(fileIds, type, expr, metadatas, exprResults, eliminated);
  }

  @Override
  public PrincipalPrivilegeSet getUserPrivilegeSet(String userName, List<String> groupNames) throws
      InvalidObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getUserPrivilegeSet(userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws
      InvalidObjectException, MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.revokePrivileges(privileges, grantOption);
    } else {
      return true;
    }
  }

  @Override
  public boolean addToken(String tokenIdentifier, String delegationToken) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.addToken(tokenIdentifier, delegationToken);
  }

  @Override
  public void setMetaStoreSchemaVersion(String version, String comment) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.setMetaStoreSchemaVersion(version, comment);
    } else {
      return;
    }
  }

  @Override
  public List<String> getAllTokenIdentifiers() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getAllTokenIdentifiers();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<RolePrincipalGrant> listRoleMembers(String roleName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listRoleMembers(roleName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public long cleanupEvents() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.cleanupEvents();
    } else {
      return 0L;
    }
  }

  @Override
  public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException,
      MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.updateMasterKey(seqNo, key);
    } else {
      return;
    }
  }

  @Override
  public boolean revokeRole(Role role, String userName, PrincipalType principalType,
      boolean grantOption) throws MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.revokeRole(role, userName, principalType, grantOption);
  }

  @Override
  public boolean createType(Type type) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.createType(type);
  }

  @Override
  public boolean removeMasterKey(Integer keySeq) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.removeMasterKey(keySeq);
  }

  @Override
  public void addNotificationEvent(NotificationEvent event) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.addNotificationEvent(event);
    } else {
      return;
    }
  }

  @Override
  public ByteBuffer[] getFileMetadata(List<Long> fileIds) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getFileMetadata(fileIds);
  }

  @Override
  public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj, List<String> partVals)
      throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(statsObj))) {
      return delegate.updatePartitionColumnStatistics(statsObj, partVals);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalTableGrantsAll(principalName, principalType);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<RolePrincipalGrant> listRolesWithGrants(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listRolesWithGrants(principalName, principalType);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException,
      MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.grantPrivileges(privileges);
    } else {
      return true;
    }
  }

  @Override
  public boolean removeToken(String tokenIdentifier) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.removeToken(tokenIdentifier);
  }

  @Override
  public String getToken(String tokenIdentifier) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getToken(tokenIdentifier);
  }

  @Override
  public List<HiveObjectPrivilege> listTableGrantsAll(String dbName, String tableName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listTableGrantsAll(dbName, tableName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public CurrentNotificationEventId getCurrentNotificationEventId() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getCurrentNotificationEventId();
    } else {
      return Empties.eventId();
    }
  }

  @Override
  public ColumnStatistics getTableColumnStatistics(String dbName, String tableName,
      List<String> colName) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTableColumnStatistics(dbName, tableName, colName);
    } else {
      return Empties.colStats();
    }
  }

  @Override
  public PrincipalPrivilegeSet getDBPrivilegeSet(String dbName, String userName,
      List<String> groupNames) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getDBPrivilegeSet(dbName, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public List<Function> getAllFunctions() throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getAllFunctions();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listDBGrantsAll(String dbName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listDBGrantsAll(dbName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public PrincipalPrivilegeSet getTablePrivilegeSet(String dbName, String tableName,
      String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTablePrivilegeSet(dbName, tableName, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public List<String> listPartitionNamesPs(String db_name, String tbl_name, List<String> part_vals,
      short max_parts) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionNamesPs(db_name, tbl_name, part_vals, max_parts);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public PrincipalPrivilegeSet getColumnPrivilegeSet(String dbName, String tableName,
      String partitionName, String columnName, String userName, List<String> groupNames) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getColumnPrivilegeSet(dbName, tableName, partitionName, columnName, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public List<String> getFunctions(String dbName, String pattern) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getFunctions(dbName, pattern);
    } else {
      return null;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listTableColumnGrantsAll(String dbName, String tableName,
      String columnName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listTableColumnGrantsAll(dbName, tableName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public boolean getPartitionsByExpr(String dbName, String tblName, byte[] expr,
      String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsByExpr(dbName, tblName, expr, defaultPartitionName, maxParts, result);
    } else {
      return nessie.getPartitionsByExpr(dbName, tblName, expr, defaultPartitionName, maxParts, result);
    }
  }

  @Override
  public List<String> getAllTables(String dbName) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getAllTables(dbName);
    } else {
      return nessie.getAllTables(dbName);
    }
  }

  @Override
  public boolean dropTable(String dbName, String tableName) throws MetaException,
      NoSuchObjectException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.dropTable(dbName, tableName);
    } else {
      return nessie.dropTable(dbName, tableName);
    }
  }

  @Override
  public boolean addPartitions(String dbName, String tblName, List<Partition> parts) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.addPartitions(dbName, tblName, parts);
    } else {
      return nessie.addPartitions(dbName, tblName, parts);
    }
  }

  @Override
  public boolean addPartitions(String dbName, String tblName, PartitionSpecProxy partitionSpec,
      boolean ifNotExists) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.addPartitions(dbName, tblName, partitionSpec, ifNotExists);
    } else {
      return nessie.addPartitions(dbName, tblName, partitionSpec, ifNotExists);
    }
  }

  @Override
  public boolean dropDatabase(String dbname) throws NoSuchObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      return delegate.dropDatabase(dbname);
    } else {
      return nessie.dropDatabase(dbname);
    }
  }

  @Override
  public boolean alterDatabase(String dbname, Database db) throws NoSuchObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      return delegate.alterDatabase(dbname, db);
    } else {
      return nessie.alterDatabase(dbname, db);
    }
  }

  @Override
  public List<Partition> getPartitionsWithAuth(String dbName, String tblName, short maxParts,
      String userName, List<String> groupNames) throws MetaException, NoSuchObjectException,
      InvalidObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
    } else {
      return nessie.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
    }
  }

  @Override
  public void createTable(Table tbl) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(tbl))) {
      delegate.createTable(tbl);
    } else {
      nessie.createTable(tbl);
    }
  }

  @Override
  public void createDatabase(Database db) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db))) {
      delegate.createDatabase(db);
    } else {
      nessie.createDatabase(db);
    }
  }

  @Override
  public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(part))) {
      return delegate.addPartition(part);
    } else {
      return nessie.addPartition(part);
    }
  }

  @Override
  public int getDatabaseCount() throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getDatabaseCount(), nessie.getDatabaseCount());
    } else {
      return nessie.getDatabaseCount();
    }
  }

  @Override
  public int getTableCount() throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getTableCount(), nessie.getTableCount());
    } else {
      return nessie.getTableCount();
    }
  }

  @Override
  public int getPartitionCount() throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getPartitionCount(), nessie.getPartitionCount());
    } else {
      return nessie.getPartitionCount();
    }
  }

  @Override
  public boolean dropPartition(String dbName, String tableName, List<String> part_vals) throws
      MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.dropPartition(dbName, tableName, part_vals);
    } else {
      return nessie.dropPartition(dbName, tableName, part_vals);
    }
  }

  @Override
  public List<TableMeta> getTableMeta(String dbNames, String tableNames, List<String> tableTypes)
      throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbNames))) {
      return delegate.getTableMeta(dbNames, tableNames, tableTypes);
    } else {
      return nessie.getTableMeta(dbNames, tableNames, tableTypes);
    }
  }

  @Override
  public List<String> getAllDatabases() throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getAllDatabases(), nessie.getAllDatabases());
    } else {
      return nessie.getAllDatabases();
    }
  }

  @Override
  public List<String> listTableNamesByFilter(String dbName, String filter, short max_tables) throws
      MetaException, UnknownDBException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.listTableNamesByFilter(dbName, filter, max_tables);
    } else {
      return nessie.listTableNamesByFilter(dbName, filter, max_tables);
    }
  }

  @Override
  public void alterTable(String dbname, String name, Table newTable) throws InvalidObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      delegate.alterTable(dbname, name, newTable);
    } else {
      nessie.alterTable(dbname, name, newTable);
    }
  }

  @Override
  public List<Table> getTableObjectsByName(String dbname, List<String> tableNames) throws
      MetaException, UnknownDBException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      return delegate.getTableObjectsByName(dbname, tableNames);
    } else {
      return nessie.getTableObjectsByName(dbname, tableNames);
    }
  }

  @Override
  public List<Partition> getPartitionsByNames(String dbName, String tblName, List<String> partNames)
      throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsByNames(dbName, tblName, partNames);
    } else {
      return nessie.getPartitionsByNames(dbName, tblName, partNames);
    }
  }

  @Override
  public boolean doesPartitionExist(String dbName, String tableName, List<String> part_vals) throws
      MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.doesPartitionExist(dbName, tableName, part_vals);
    } else {
      return nessie.doesPartitionExist(dbName, tableName, part_vals);
    }
  }

  @Override
  public List<Partition> getPartitionsByFilter(String dbName, String tblName, String filter,
      short maxParts) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsByFilter(dbName, tblName, filter, maxParts);
    } else {
      return nessie.getPartitionsByFilter(dbName, tblName, filter, maxParts);
    }
  }

  @Override
  public List<String> getTables(String dbName, String pattern) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTables(dbName, pattern);
    } else {
      return nessie.getTables(dbName, pattern);
    }
  }

  @Override
  public List<String> getTables(String dbName, String pattern, TableType tableType) throws
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTables(dbName, pattern, tableType);
    } else {
      return nessie.getTables(dbName, pattern, tableType);
    }
  }

  @Override
  public Partition getPartitionWithAuth(String dbName, String tblName, List<String> partVals,
      String user_name, List<String> group_names) throws MetaException, NoSuchObjectException,
      InvalidObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionWithAuth(dbName, tblName, partVals, user_name, group_names);
    } else {
      return nessie.getPartitionWithAuth(dbName, tblName, partVals, user_name, group_names);
    }
  }

  @Override
  public Database getDatabase(String name) throws NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(name))) {
      return delegate.getDatabase(name);
    } else {
      return nessie.getDatabase(name);
    }
  }

  @Override
  public List<String> getDatabases(String pattern) throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getDatabases(pattern), nessie.getDatabases(pattern));
    } else {
      return nessie.getDatabases(pattern);
    }
  }

  @Override
  public void dropPartitions(String dbName, String tblName, List<String> partNames) throws
      MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      delegate.dropPartitions(dbName, tblName, partNames);
    } else {
      nessie.dropPartitions(dbName, tblName, partNames);
    }
  }

  @Override
  public Partition getPartition(String dbName, String tableName, List<String> part_vals) throws
      MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartition(dbName, tableName, part_vals);
    } else {
      return nessie.getPartition(dbName, tableName, part_vals);
    }
  }

  @Override
  public List<String> listPartitionNames(String db_name, String tbl_name, short max_parts) throws
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionNames(db_name, tbl_name, max_parts);
    } else {
      return nessie.listPartitionNames(db_name, tbl_name, max_parts);
    }
  }

  @Override
  public int getNumPartitionsByFilter(String dbName, String tblName, String filter) throws
      MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getNumPartitionsByFilter(dbName, tblName, filter);
    } else {
      return nessie.getNumPartitionsByFilter(dbName, tblName, filter);
    }
  }

  @Override
  public PartitionValuesResponse listPartitionValues(String db_name, String tbl_name,
      List<FieldSchema> cols, boolean applyDistinct, String filter, boolean ascending,
      List<FieldSchema> order, long maxParts) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionValues(db_name, tbl_name, cols, applyDistinct, filter, ascending, order, maxParts);
    } else {
      return nessie.listPartitionValues(db_name, tbl_name, cols, applyDistinct, filter, ascending, order, maxParts);
    }
  }

  @Override
  public int getNumPartitionsByExpr(String dbName, String tblName, byte[] expr) throws
      MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getNumPartitionsByExpr(dbName, tblName, expr);
    } else {
      return nessie.getNumPartitionsByExpr(dbName, tblName, expr);
    }
  }

  @Override
  public List<String> listPartitionNamesByFilter(String db_name, String tbl_name, String filter,
      short max_parts) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionNamesByFilter(db_name, tbl_name, filter, max_parts);
    } else {
      return nessie.listPartitionNamesByFilter(db_name, tbl_name, filter, max_parts);
    }
  }

  @Override
  public List<Partition> listPartitionsPsWithAuth(String db_name, String tbl_name,
      List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws
      MetaException, InvalidObjectException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
    } else {
      return nessie.listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
    }
  }

  @Override
  public void alterPartition(String db_name, String tbl_name, List<String> part_vals,
      Partition new_part) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      delegate.alterPartition(db_name, tbl_name, part_vals, new_part);
    } else {
      nessie.alterPartition(db_name, tbl_name, part_vals, new_part);
    }
  }

  @Override
  public List<HiveObjectPrivilege> listAllTableGrants(String principalName,
      PrincipalType principalType, String dbName, String tableName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listAllTableGrants(principalName, principalType, dbName, tableName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public boolean dropIndex(String dbName, String origTableName, String indexName) throws
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      return delegate.dropIndex(dbName, origTableName, indexName);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<Index> getIndexes(String dbName, String origTableName, int max) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getIndexes(dbName, origTableName, max);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public boolean addIndex(Index index) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(index))) {
      return delegate.addIndex(index);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String principalName,
      PrincipalType principalType, String dbName, String tableName, List<String> partValues,
      String partName, String columnName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalPartitionColumnGrants(principalName, principalType, dbName, tableName, partValues, partName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<String> listIndexNames(String dbName, String origTableName, short max) throws
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listIndexNames(dbName, origTableName, max);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String principalName,
      PrincipalType principalType, String dbName, String tableName, String columnName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public Type getType(String typeName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getType(typeName);
  }

  @Override
  public Function getFunction(String dbName, String funcName) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getFunction(dbName, funcName);
    } else {
      return null;
    }
  }

  @Override
  public void createFunction(Function func) throws InvalidObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createFunction(func);
  }

  @Override
  public Index getIndex(String dbName, String origTableName, String indexName) throws
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getIndex(dbName, origTableName, indexName);
    } else {
      return null;
    }
  }
}
