/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.net.URI;
import java.util.function.Function;
import org.projectnessie.api.ConfigApi;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.client.NessieHttpClient;

public interface NessieClient
extends AutoCloseable {
    @Override
    public void close();

    public TreeApi getTreeApi();

    public ContentsApi getContentsApi();

    public ConfigApi getConfigApi();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AuthType authType = AuthType.NONE;
        private URI uri;
        private String username;
        private String password;
        private boolean tracing;
        private int readTimeoutMillis = Integer.parseInt(System.getProperty("sun.net.client.defaultReadTimeout", "25000"));
        private int connectionTimeoutMillis = Integer.parseInt(System.getProperty("sun.net.client.defaultConnectionTimeout", "5000"));

        public Builder fromSystemProperties() {
            return this.fromConfig(System::getProperty);
        }

        public Builder fromConfig(Function<String, String> configuration) {
            String tracing;
            String authType;
            String password;
            String username;
            String uri = configuration.apply("nessie.uri");
            if (uri == null) {
                uri = configuration.apply("nessie.url");
            }
            if (uri != null) {
                this.uri = URI.create(uri);
            }
            if ((username = configuration.apply("nessie.username")) != null) {
                this.username = username;
            }
            if ((password = configuration.apply("nessie.password")) != null) {
                this.password = password;
            }
            if ((authType = configuration.apply("nessie.auth_type")) != null) {
                this.authType = AuthType.valueOf(authType);
            }
            if ((tracing = configuration.apply("nessie.tracing")) != null) {
                this.tracing = Boolean.parseBoolean(tracing);
            }
            return this;
        }

        public Builder withAuthType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withUri(String uri) {
            return this.withUri(URI.create(uri));
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withTracing(boolean tracing) {
            this.tracing = tracing;
            return this;
        }

        public Builder withReadTimeout(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder withConnectionTimeout(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public NessieClient build() {
            return new NessieHttpClient(this.authType, this.uri, this.username, this.password, this.tracing, this.readTimeoutMillis, this.connectionTimeoutMillis);
        }
    }

    public static enum AuthType {
        AWS,
        BASIC,
        NONE;

    }
}

