/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.projectnessie.hms.PartitionFilterer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive2PartitionFilterer
implements PartitionFilterer.PartitionFiltererImpl {
    private static Logger LOG = LoggerFactory.getLogger(Hive2PartitionFilterer.class);

    @Override
    public boolean filterPartitionsByExpr(Configuration conf, List<FieldSchema> partColumns, byte[] expr, List<String> partitionNames) throws MetaException {
        String defaultPartName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        PartitionExpressionProxy pems = Hive2PartitionFilterer.createExpressionProxy(conf);
        return pems.filterPartitionsByExpr(partColumns.stream().map(FieldSchema::getName).collect(Collectors.toList()), partColumns.stream().map(FieldSchema::getType).map(TypeInfoFactory::getPrimitiveTypeInfo).collect(Collectors.toList()), expr, defaultPartName, partitionNames);
    }

    private static PartitionExpressionProxy createExpressionProxy(Configuration conf) {
        String className = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS);
        try {
            Class clazz = JavaUtils.loadClass((String)className);
            return (PartitionExpressionProxy)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error("Error loading PartitionExpressionProxy", (Throwable)e);
            throw new RuntimeException("Error loading PartitionExpressionProxy: " + e.getMessage());
        }
    }
}

