/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Contents;
import org.projectnessie.model.HiveTable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HiveTable", generator="Immutables")
@Immutable
public final class ImmutableHiveTable
extends HiveTable {
    private final String id;
    private final byte[] tableDefinition;
    private final List<byte[]> partitions;
    private final transient int hashCode;

    private ImmutableHiveTable(Builder builder) {
        this.tableDefinition = builder.tableDefinition;
        this.partitions = ImmutableHiveTable.createUnmodifiableList(true, builder.partitions);
        this.id = builder.id != null ? builder.id : Objects.requireNonNull(super.getId(), "id");
        this.hashCode = super.hashCode();
    }

    private ImmutableHiveTable(String id, byte[] tableDefinition, List<byte[]> partitions) {
        this.id = id;
        this.tableDefinition = tableDefinition;
        this.partitions = partitions;
        this.hashCode = super.hashCode();
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="tableDefinition")
    public byte[] getTableDefinition() {
        return (byte[])this.tableDefinition.clone();
    }

    @Override
    @JsonProperty(value="partitions")
    public List<byte[]> getPartitions() {
        return this.partitions;
    }

    public final ImmutableHiveTable withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableHiveTable(newValue, this.tableDefinition, this.partitions);
    }

    public final ImmutableHiveTable withTableDefinition(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableHiveTable(this.id, newValue, this.partitions);
    }

    public final ImmutableHiveTable withPartitions(byte[] ... elements) {
        List<byte[]> newValue = ImmutableHiveTable.createUnmodifiableList(false, ImmutableHiveTable.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHiveTable(this.id, this.tableDefinition, newValue);
    }

    public final ImmutableHiveTable withPartitions(Iterable<? extends byte[]> elements) {
        if (this.partitions == elements) {
            return this;
        }
        List<byte[]> newValue = ImmutableHiveTable.createUnmodifiableList(false, ImmutableHiveTable.createSafeList(elements, true, false));
        return new ImmutableHiveTable(this.id, this.tableDefinition, newValue);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "HiveTable{id=" + this.id + ", tableDefinition=" + Arrays.toString(this.tableDefinition) + ", partitions=" + this.partitions + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHiveTable fromJson(Json json) {
        Builder builder = ImmutableHiveTable.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.tableDefinition != null) {
            builder.tableDefinition(json.tableDefinition);
        }
        if (json.partitions != null) {
            builder.addAllPartitions(json.partitions);
        }
        return builder.build();
    }

    public static ImmutableHiveTable copyOf(HiveTable instance) {
        if (instance instanceof ImmutableHiveTable) {
            return (ImmutableHiveTable)instance;
        }
        return ImmutableHiveTable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="HiveTable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TABLE_DEFINITION = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private byte[] tableDefinition;
        private List<byte[]> partitions = new ArrayList<byte[]>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Contents instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(HiveTable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Contents instance;
            if (object instanceof Contents) {
                instance = (Contents)object;
                this.id(instance.getId());
            }
            if (object instanceof HiveTable) {
                instance = (HiveTable)object;
                this.addAllPartitions(((HiveTable)instance).getPartitions());
                this.tableDefinition(((HiveTable)instance).getTableDefinition());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="tableDefinition")
        @CanIgnoreReturnValue
        public final Builder tableDefinition(byte ... tableDefinition) {
            this.tableDefinition = (byte[])tableDefinition.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartitions(byte[] element) {
            this.partitions.add(Objects.requireNonNull(element, "partitions element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartitions(byte[] ... elements) {
            for (byte[] element : elements) {
                this.partitions.add(Objects.requireNonNull(element, "partitions element"));
            }
            return this;
        }

        @JsonProperty(value="partitions")
        @CanIgnoreReturnValue
        public final Builder partitions(Iterable<? extends byte[]> elements) {
            this.partitions.clear();
            return this.addAllPartitions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPartitions(Iterable<? extends byte[]> elements) {
            for (byte[] byArray : elements) {
                this.partitions.add(Objects.requireNonNull(byArray, "partitions element"));
            }
            return this;
        }

        public ImmutableHiveTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHiveTable(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tableDefinition");
            }
            return "Cannot build HiveTable, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HiveTable", generator="Immutables")
    static final class Json
    extends HiveTable {
        @Nullable
        String id;
        @Nullable
        byte[] tableDefinition;
        @Nullable
        List<byte[]> partitions = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="tableDefinition")
        public void setTableDefinition(byte[] tableDefinition) {
            this.tableDefinition = tableDefinition;
        }

        @JsonProperty(value="partitions")
        public void setPartitions(List<byte[]> partitions) {
            this.partitions = partitions;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getTableDefinition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<byte[]> getPartitions() {
            throw new UnsupportedOperationException();
        }
    }
}

