/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;

public class EntriesParams {
    @Parameter(description="maximum number of entries to return, just a hint for the server")
    @QueryParam(value="max")
    private Integer maxRecords;
    @Parameter(description="pagination continuation token, as returned in the previous EntriesResponse.token")
    @QueryParam(value="pageToken")
    private String pageToken;
    @Parameter(description="list of value types to return. Return all if empty", examples={@ExampleObject(ref="types")})
    @QueryParam(value="types")
    private List<String> types;
    @Parameter(description="The namespace to filter by. For a given table name 'a.b.c.tableName', the namespace is 'a.b.c', thus a validnamespace to filter by would be 'a' / 'a.b' / 'a.b.c'. Setting the namespace filter to 'a.b.c.tableName' would not return anyresults, because 'tableName' is not part of the namespace.No filtering will happen if this is set to null/empty", examples={@ExampleObject(ref="namespace")})
    @QueryParam(value="namespace")
    private String namespace;

    public EntriesParams() {
    }

    private EntriesParams(Integer maxRecords, String pageToken, List<String> types, String namespace) {
        this.maxRecords = maxRecords;
        this.pageToken = pageToken;
        this.types = types;
        this.namespace = namespace;
    }

    private EntriesParams(Builder builder) {
        this(builder.maxRecords, builder.pageToken, builder.types, builder.namespace);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EntriesParams empty() {
        return new Builder().build();
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        return new StringJoiner(", ", EntriesParams.class.getSimpleName() + "[", "]").add("maxRecords=" + this.maxRecords).add("pageToken='" + this.pageToken + "'").add("types=" + this.types).add("namespace='" + this.namespace + "'").toString();
    }

    public static class Builder {
        private Integer maxRecords;
        private String pageToken;
        private String namespace;
        private List<String> types = Collections.emptyList();

        private Builder() {
        }

        public Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder types(List<String> types) {
            this.types = types;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder from(EntriesParams params) {
            return this.maxRecords(params.maxRecords).pageToken(params.pageToken).namespace(params.namespace).types(params.types);
        }

        private void validate() {
            Objects.requireNonNull(this.types, "types must be non-null");
        }

        public EntriesParams build() {
            this.validate();
            return new EntriesParams(this);
        }
    }
}

