/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.FileMetadataHandler;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.projectnessie.hms.BaseRawStore;
import org.projectnessie.hms.Empties;

public class Hive2NessieRawStore
extends BaseRawStore {
    public Hive2NessieRawStore() {
        super(false);
    }

    public Hive2NessieRawStore(boolean delegate) {
        super(delegate);
    }

    public Table getTable(String dbName, String tableName) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getTable(dbName, tableName);
        }
        return this.nessie.getTable(dbName, tableName);
    }

    public Type getType(String typeName) {
        this.checkHasDelegate();
        return this.delegate.getType(typeName);
    }

    public Function getFunction(String dbName, String funcName) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getFunction(dbName, funcName);
        }
        return null;
    }

    public void createFunction(Function func) throws InvalidObjectException, MetaException {
        this.checkHasDelegate();
        this.delegate.createFunction(func);
    }

    public Index getIndex(String dbName, String origTableName, String indexName) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getIndex(dbName, origTableName, indexName);
        }
        return null;
    }

    public List<Partition> getPartitions(String dbName, String tableName, int max) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitions(dbName, tableName, max);
        }
        return this.nessie.getPartitions(dbName, tableName, max);
    }

    public void alterPartitions(String db_name, String tbl_name, List<List<String>> part_vals_list, List<Partition> new_parts) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            this.delegate.alterPartitions(db_name, tbl_name, part_vals_list, new_parts);
        } else {
            this.nessie.alterPartitions(db_name, tbl_name, part_vals_list, new_parts);
        }
    }

    public List<Partition> listPartitionsPsWithAuth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, InvalidObjectException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            return this.delegate.listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
        }
        return this.nessie.listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
    }

    public void alterPartition(String db_name, String tbl_name, List<String> part_vals, Partition new_part) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            this.delegate.alterPartition(db_name, tbl_name, part_vals, new_part);
        } else {
            this.nessie.alterPartition(db_name, tbl_name, part_vals, new_part);
        }
    }

    public boolean getPartitionsByExpr(String dbName, String tblName, byte[] expr, String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitionsByExpr(dbName, tblName, expr, defaultPartitionName, maxParts, result);
        }
        return this.nessie.getPartitionsByExpr(dbName, tblName, expr, defaultPartitionName, maxParts, result);
    }

    public List<String> getAllTables(String dbName) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getAllTables(dbName);
        }
        return this.nessie.getAllTables(dbName);
    }

    public boolean dropTable(String dbName, String tableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.dropTable(dbName, tableName);
        }
        return this.nessie.dropTable(dbName, tableName);
    }

    public boolean addPartitions(String dbName, String tblName, PartitionSpecProxy partitionSpec, boolean ifNotExists) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.addPartitions(dbName, tblName, partitionSpec, ifNotExists);
        }
        return this.nessie.addPartitions(dbName, tblName, partitionSpec, ifNotExists);
    }

    public boolean addPartitions(String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.addPartitions(dbName, tblName, parts);
        }
        return this.nessie.addPartitions(dbName, tblName, parts);
    }

    public boolean dropDatabase(String dbname) throws NoSuchObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbname))) {
            return this.delegate.dropDatabase(dbname);
        }
        return this.nessie.dropDatabase(dbname);
    }

    public boolean alterDatabase(String dbname, Database db) throws NoSuchObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbname))) {
            return this.delegate.alterDatabase(dbname, db);
        }
        return this.nessie.alterDatabase(dbname, db);
    }

    public List<Partition> getPartitionsWithAuth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws MetaException, NoSuchObjectException, InvalidObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
        }
        return this.nessie.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
    }

    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(tbl))) {
            this.delegate.createTable(tbl);
        } else {
            this.nessie.createTable(tbl);
        }
    }

    public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db))) {
            this.delegate.createDatabase(db);
        } else {
            this.nessie.createDatabase(db);
        }
    }

    public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(part))) {
            return this.delegate.addPartition(part);
        }
        return this.nessie.addPartition(part);
    }

    public int getDatabaseCount() throws MetaException {
        if (this.hasDelegate) {
            return Hive2NessieRawStore.union(this.delegate.getDatabaseCount(), this.nessie.getDatabaseCount());
        }
        return this.nessie.getDatabaseCount();
    }

    public int getTableCount() throws MetaException {
        if (this.hasDelegate) {
            return Hive2NessieRawStore.union(this.delegate.getTableCount(), this.nessie.getTableCount());
        }
        return this.nessie.getTableCount();
    }

    public int getPartitionCount() throws MetaException {
        if (this.hasDelegate) {
            return Hive2NessieRawStore.union(this.delegate.getPartitionCount(), this.nessie.getPartitionCount());
        }
        return this.nessie.getPartitionCount();
    }

    public boolean dropPartition(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.dropPartition(dbName, tableName, part_vals);
        }
        return this.nessie.dropPartition(dbName, tableName, part_vals);
    }

    public List<TableMeta> getTableMeta(String dbNames, String tableNames, List<String> tableTypes) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbNames))) {
            return this.delegate.getTableMeta(dbNames, tableNames, tableTypes);
        }
        return this.nessie.getTableMeta(dbNames, tableNames, tableTypes);
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getFunctions(dbName, pattern);
        }
        return null;
    }

    public List<HiveObjectPrivilege> listTableColumnGrantsAll(String dbName, String tableName, String columnName) {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.listTableColumnGrantsAll(dbName, tableName, columnName);
        }
        return Collections.emptyList();
    }

    public List<ColumnStatistics> getPartitionColumnStatistics(String dbName, String tblName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitionColumnStatistics(dbName, tblName, partNames, colNames);
        }
        return Collections.emptyList();
    }

    public void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        if (!this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            throw new IllegalArgumentException("Loud Failure");
        }
        this.delegate.dropFunction(dbName, funcName);
    }

    public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String dbName, String tableName, String partitionName, String columnName) {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.listPartitionColumnGrantsAll(dbName, tableName, partitionName, columnName);
        }
        return Collections.emptyList();
    }

    public void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException {
        if (!this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            throw new IllegalArgumentException("Loud Failure");
        }
        this.delegate.alterFunction(dbName, funcName, newFunction);
    }

    public AggrStats get_aggr_stats_for(String dbName, String tblName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.get_aggr_stats_for(dbName, tblName, partNames, colNames);
        }
        throw new IllegalArgumentException("Loud Failure");
    }

    public FileMetadataHandler getFileMetadataHandler(FileMetadataExprType type) {
        this.checkHasDelegate();
        return this.delegate.getFileMetadataHandler(type);
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata, FileMetadataExprType type) throws MetaException {
        this.checkHasDelegate();
        this.delegate.putFileMetadata(fileIds, metadata, type);
    }

    public List<SQLForeignKey> getForeignKeys(String parent_db_name, String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(parent_db_name))) {
            return this.delegate.getForeignKeys(parent_db_name, parent_tbl_name, foreign_db_name, foreign_tbl_name);
        }
        return Collections.emptyList();
    }

    public List<SQLPrimaryKey> getPrimaryKeys(String db_name, String tbl_name) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            return this.delegate.getPrimaryKeys(db_name, tbl_name);
        }
        return Collections.emptyList();
    }

    public void dropConstraint(String dbName, String tableName, String constraintName) throws NoSuchObjectException {
        if (!this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return;
        }
        this.delegate.dropConstraint(dbName, tableName, constraintName);
    }

    public void alterIndex(String dbname, String baseTblName, String name, Index newIndex) throws InvalidObjectException, MetaException {
        if (!this.routeToDelegate(Hive2NessieRawStore.route(dbname))) {
            throw new IllegalArgumentException("Loud Failure");
        }
        this.delegate.alterIndex(dbname, baseTblName, name, newIndex);
    }

    public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String principalName, PrincipalType principalType) {
        this.checkHasDelegate();
        return this.delegate.listPrincipalDBGrantsAll(principalName, principalType);
    }

    public boolean grantRole(Role role, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, NoSuchObjectException, InvalidObjectException {
        this.checkHasDelegate();
        return this.delegate.grantRole(role, userName, principalType, grantor, grantorType, grantOption);
    }

    public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String principalName, PrincipalType principalType) {
        this.checkHasDelegate();
        return this.delegate.listPrincipalPartitionGrantsAll(principalName, principalType);
    }

    public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String principalName, PrincipalType principalType) {
        this.checkHasDelegate();
        return this.delegate.listPrincipalTableColumnGrantsAll(principalName, principalType);
    }

    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String principalName, PrincipalType principalType) {
        this.checkHasDelegate();
        return this.delegate.listPrincipalPartitionColumnGrantsAll(principalName, principalType);
    }

    public void verifySchema() throws MetaException {
        if (!this.hasDelegate) {
            return;
        }
        this.delegate.verifySchema();
    }

    public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String principalName, PrincipalType principalType) {
        this.checkHasDelegate();
        return this.delegate.listPrincipalGlobalGrants(principalName, principalType);
    }

    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        this.checkHasDelegate();
        return this.delegate.listRoles(principalName, principalType);
    }

    public int addMasterKey(String key) throws MetaException {
        this.checkHasDelegate();
        return this.delegate.addMasterKey(key);
    }

    public boolean removeRole(String roleName) throws MetaException, NoSuchObjectException {
        this.checkHasDelegate();
        return this.delegate.removeRole(roleName);
    }

    public void cleanNotificationEvents(int olderThan) {
        if (!this.hasDelegate) {
            return;
        }
        this.delegate.cleanNotificationEvents(olderThan);
    }

    public void flushCache() {
        if (!this.hasDelegate) {
            return;
        }
        this.delegate.flushCache();
    }

    public boolean updateTableColumnStatistics(ColumnStatistics colStats) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        if (this.hasDelegate) {
            return this.delegate.updateTableColumnStatistics(colStats);
        }
        return true;
    }

    public boolean isFileMetadataSupported() {
        if (this.hasDelegate) {
            return this.delegate.isFileMetadataSupported();
        }
        return true;
    }

    public List<HiveObjectPrivilege> listGlobalGrantsAll() {
        if (this.hasDelegate) {
            return this.delegate.listGlobalGrantsAll();
        }
        return Collections.emptyList();
    }

    public Role getRole(String roleName) throws NoSuchObjectException {
        this.checkHasDelegate();
        return this.delegate.getRole(roleName);
    }

    public String[] getMasterKeys() {
        if (this.hasDelegate) {
            return this.delegate.getMasterKeys();
        }
        return new String[0];
    }

    public void getFileMetadataByExpr(List<Long> fileIds, FileMetadataExprType type, byte[] expr, ByteBuffer[] metadatas, ByteBuffer[] exprResults, boolean[] eliminated) throws MetaException {
        this.checkHasDelegate();
        this.delegate.getFileMetadataByExpr(fileIds, type, expr, metadatas, exprResults, eliminated);
    }

    public void addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException, MetaException {
        if (!this.routeToDelegate(fks.stream().flatMap(BaseRawStore::route))) {
            throw new IllegalArgumentException("Loud Failure");
        }
        this.delegate.addForeignKeys(fks);
    }

    public void addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
        if (!this.routeToDelegate(pks.stream().flatMap(BaseRawStore::route))) {
            throw new IllegalArgumentException("Loud Failure");
        }
        this.delegate.addPrimaryKeys(pks);
    }

    public boolean dropType(String typeName) {
        this.checkHasDelegate();
        return this.delegate.dropType(typeName);
    }

    public List<String> listRoleNames() {
        if (this.hasDelegate) {
            return this.delegate.listRoleNames();
        }
        return Collections.emptyList();
    }

    public boolean addRole(String rowName, String ownerName) throws InvalidObjectException, MetaException, NoSuchObjectException {
        if (this.hasDelegate) {
            return this.delegate.addRole(rowName, ownerName);
        }
        return true;
    }

    public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String principalName, PrincipalType principalType) {
        if (this.hasDelegate) {
            return this.delegate.listPrincipalTableGrantsAll(principalName, principalType);
        }
        return Collections.emptyList();
    }

    public List<RolePrincipalGrant> listRolesWithGrants(String principalName, PrincipalType principalType) {
        if (this.hasDelegate) {
            return this.delegate.listRolesWithGrants(principalName, principalType);
        }
        return Collections.emptyList();
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
        if (this.hasDelegate) {
            return this.delegate.grantPrivileges(privileges);
        }
        return true;
    }

    public boolean removeToken(String tokenIdentifier) {
        this.checkHasDelegate();
        return this.delegate.removeToken(tokenIdentifier);
    }

    public String getToken(String tokenIdentifier) {
        this.checkHasDelegate();
        return this.delegate.getToken(tokenIdentifier);
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() {
        if (this.hasDelegate) {
            return this.delegate.getCurrentNotificationEventId();
        }
        return Empties.eventId();
    }

    public List<HiveObjectPrivilege> listTableGrantsAll(String dbName, String tableName) {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.listTableGrantsAll(dbName, tableName);
        }
        return Collections.emptyList();
    }

    public ColumnStatistics getTableColumnStatistics(String dbName, String tableName, List<String> colName) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getTableColumnStatistics(dbName, tableName, colName);
        }
        return Empties.colStats();
    }

    public PrincipalPrivilegeSet getDBPrivilegeSet(String dbName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getDBPrivilegeSet(dbName, userName, groupNames);
        }
        return Empties.privSet();
    }

    public List<Function> getAllFunctions() throws MetaException {
        if (this.hasDelegate) {
            return this.delegate.getAllFunctions();
        }
        return Collections.emptyList();
    }

    public List<HiveObjectPrivilege> listDBGrantsAll(String dbName) {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.listDBGrantsAll(dbName);
        }
        return Collections.emptyList();
    }

    public PrincipalPrivilegeSet getTablePrivilegeSet(String dbName, String tableName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getTablePrivilegeSet(dbName, tableName, userName, groupNames);
        }
        return Empties.privSet();
    }

    public List<String> listPartitionNamesPs(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            return this.delegate.listPartitionNamesPs(db_name, tbl_name, part_vals, max_parts);
        }
        return Collections.emptyList();
    }

    public PrincipalPrivilegeSet getColumnPrivilegeSet(String dbName, String tableName, String partitionName, String columnName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getColumnPrivilegeSet(dbName, tableName, partitionName, columnName, userName, groupNames);
        }
        return Empties.privSet();
    }

    public List<HiveObjectPrivilege> listPrincipalDBGrants(String principalName, PrincipalType principalType, String dbName) {
        if (this.hasDelegate) {
            return this.delegate.listPrincipalDBGrants(principalName, principalType, dbName);
        }
        return Collections.emptyList();
    }

    public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String partName) {
        if (this.hasDelegate) {
            return this.delegate.listPrincipalPartitionGrants(principalName, principalType, dbName, tableName, partValues, partName);
        }
        return Collections.emptyList();
    }

    public List<HiveObjectPrivilege> listAllTableGrants(String principalName, PrincipalType principalType, String dbName, String tableName) {
        if (this.hasDelegate) {
            return this.delegate.listAllTableGrants(principalName, principalType, dbName, tableName);
        }
        return Collections.emptyList();
    }

    public boolean dropIndex(String dbName, String origTableName, String indexName) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.dropIndex(dbName, origTableName, indexName);
        }
        throw new IllegalArgumentException("Loud Failure");
    }

    public List<Index> getIndexes(String dbName, String origTableName, int max) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getIndexes(dbName, origTableName, max);
        }
        return Collections.emptyList();
    }

    public boolean addIndex(Index index) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(index))) {
            return this.delegate.addIndex(index);
        }
        throw new IllegalArgumentException("Loud Failure");
    }

    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String partName, String columnName) {
        if (this.hasDelegate) {
            return this.delegate.listPrincipalPartitionColumnGrants(principalName, principalType, dbName, tableName, partValues, partName, columnName);
        }
        return Collections.emptyList();
    }

    public List<String> listIndexNames(String dbName, String origTableName, short max) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.listIndexNames(dbName, origTableName, max);
        }
        return Collections.emptyList();
    }

    public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, String columnName) {
        if (this.hasDelegate) {
            return this.delegate.listPrincipalTableColumnGrants(principalName, principalType, dbName, tableName, columnName);
        }
        return Collections.emptyList();
    }

    public List<String> getAllDatabases() throws MetaException {
        if (this.hasDelegate) {
            return Hive2NessieRawStore.union(this.delegate.getAllDatabases(), this.nessie.getAllDatabases());
        }
        return this.nessie.getAllDatabases();
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short max_tables) throws MetaException, UnknownDBException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.listTableNamesByFilter(dbName, filter, max_tables);
        }
        return this.nessie.listTableNamesByFilter(dbName, filter, max_tables);
    }

    public void alterTable(String dbname, String name, Table newTable) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbname))) {
            this.delegate.alterTable(dbname, name, newTable);
        } else {
            this.nessie.alterTable(dbname, name, newTable);
        }
    }

    public List<Table> getTableObjectsByName(String dbname, List<String> tableNames) throws MetaException, UnknownDBException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbname))) {
            return this.delegate.getTableObjectsByName(dbname, tableNames);
        }
        return this.nessie.getTableObjectsByName(dbname, tableNames);
    }

    public List<Partition> getPartitionsByNames(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitionsByNames(dbName, tblName, partNames);
        }
        return this.nessie.getPartitionsByNames(dbName, tblName, partNames);
    }

    public boolean doesPartitionExist(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.doesPartitionExist(dbName, tableName, part_vals);
        }
        return this.nessie.doesPartitionExist(dbName, tableName, part_vals);
    }

    public List<Partition> getPartitionsByFilter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitionsByFilter(dbName, tblName, filter, maxParts);
        }
        return this.nessie.getPartitionsByFilter(dbName, tblName, filter, maxParts);
    }

    public List<String> getTables(String dbName, String pattern) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getTables(dbName, pattern);
        }
        return this.nessie.getTables(dbName, pattern);
    }

    public List<String> getTables(String dbName, String pattern, TableType tableType) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getTables(dbName, pattern, tableType);
        }
        return this.nessie.getTables(dbName, pattern, tableType);
    }

    public Partition getPartitionWithAuth(String dbName, String tblName, List<String> partVals, String user_name, List<String> group_names) throws MetaException, NoSuchObjectException, InvalidObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitionWithAuth(dbName, tblName, partVals, user_name, group_names);
        }
        return this.nessie.getPartitionWithAuth(dbName, tblName, partVals, user_name, group_names);
    }

    public Database getDatabase(String name) throws NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(name))) {
            return this.delegate.getDatabase(name);
        }
        return this.nessie.getDatabase(name);
    }

    public List<String> getDatabases(String pattern) throws MetaException {
        if (this.hasDelegate) {
            return Hive2NessieRawStore.union(this.delegate.getDatabases(pattern), this.nessie.getDatabases(pattern));
        }
        return this.nessie.getDatabases(pattern);
    }

    public void dropPartitions(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            this.delegate.dropPartitions(dbName, tblName, partNames);
        } else {
            this.nessie.dropPartitions(dbName, tblName, partNames);
        }
    }

    public Partition getPartition(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartition(dbName, tableName, part_vals);
        }
        return this.nessie.getPartition(dbName, tableName, part_vals);
    }

    public List<String> listPartitionNames(String db_name, String tbl_name, short max_parts) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            return this.delegate.listPartitionNames(db_name, tbl_name, max_parts);
        }
        return this.nessie.listPartitionNames(db_name, tbl_name, max_parts);
    }

    public int getNumPartitionsByFilter(String dbName, String tblName, String filter) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getNumPartitionsByFilter(dbName, tblName, filter);
        }
        return this.nessie.getNumPartitionsByFilter(dbName, tblName, filter);
    }

    public PartitionValuesResponse listPartitionValues(String db_name, String tbl_name, List<FieldSchema> cols, boolean applyDistinct, String filter, boolean ascending, List<FieldSchema> order, long maxParts) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            return this.delegate.listPartitionValues(db_name, tbl_name, cols, applyDistinct, filter, ascending, order, maxParts);
        }
        return this.nessie.listPartitionValues(db_name, tbl_name, cols, applyDistinct, filter, ascending, order, maxParts);
    }

    public int getNumPartitionsByExpr(String dbName, String tblName, byte[] expr) throws MetaException, NoSuchObjectException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getNumPartitionsByExpr(dbName, tblName, expr);
        }
        return this.nessie.getNumPartitionsByExpr(dbName, tblName, expr);
    }

    public List<String> listPartitionNamesByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(db_name))) {
            return this.delegate.listPartitionNamesByFilter(db_name, tbl_name, filter, max_parts);
        }
        return this.nessie.listPartitionNamesByFilter(db_name, tbl_name, filter, max_parts);
    }

    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        if (this.hasDelegate) {
            return this.delegate.getNextNotification(rqst);
        }
        return Empties.event();
    }

    public PrincipalPrivilegeSet getUserPrivilegeSet(String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        if (this.hasDelegate) {
            return this.delegate.getUserPrivilegeSet(userName, groupNames);
        }
        return Empties.privSet();
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws InvalidObjectException, MetaException, NoSuchObjectException {
        if (this.hasDelegate) {
            return this.delegate.revokePrivileges(privileges, grantOption);
        }
        return true;
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) {
        this.checkHasDelegate();
        return this.delegate.addToken(tokenIdentifier, delegationToken);
    }

    public void setMetaStoreSchemaVersion(String version, String comment) throws MetaException {
        if (!this.hasDelegate) {
            return;
        }
        this.delegate.setMetaStoreSchemaVersion(version, comment);
    }

    public List<String> getAllTokenIdentifiers() {
        if (this.hasDelegate) {
            return this.delegate.getAllTokenIdentifiers();
        }
        return Collections.emptyList();
    }

    public List<RolePrincipalGrant> listRoleMembers(String roleName) {
        if (this.hasDelegate) {
            return this.delegate.listRoleMembers(roleName);
        }
        return Collections.emptyList();
    }

    public long cleanupEvents() {
        if (this.hasDelegate) {
            return this.delegate.cleanupEvents();
        }
        return 0L;
    }

    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException {
        if (!this.hasDelegate) {
            return;
        }
        this.delegate.updateMasterKey(seqNo, key);
    }

    public boolean revokeRole(Role role, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, NoSuchObjectException {
        this.checkHasDelegate();
        return this.delegate.revokeRole(role, userName, principalType, grantOption);
    }

    public boolean createType(Type type) {
        this.checkHasDelegate();
        return this.delegate.createType(type);
    }

    public boolean removeMasterKey(Integer keySeq) {
        this.checkHasDelegate();
        return this.delegate.removeMasterKey(keySeq);
    }

    public void addNotificationEvent(NotificationEvent event) {
        if (!this.hasDelegate) {
            return;
        }
        this.delegate.addNotificationEvent(event);
    }

    public ByteBuffer[] getFileMetadata(List<Long> fileIds) throws MetaException {
        this.checkHasDelegate();
        return this.delegate.getFileMetadata(fileIds);
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj, List<String> partVals) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(statsObj))) {
            return this.delegate.updatePartitionColumnStatistics(statsObj, partVals);
        }
        throw new IllegalArgumentException("Loud Failure");
    }

    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws InvalidObjectException, MetaException {
        if (!this.routeToDelegate(Hive2NessieRawStore.route(tbl))) {
            throw new IllegalArgumentException("Loud Failure");
        }
        this.delegate.createTableWithConstraints(tbl, primaryKeys, foreignKeys);
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, List<String> partVals, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.deletePartitionColumnStatistics(dbName, tableName, partName, partVals, colName);
        }
        return true;
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partName, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.isPartitionMarkedForEvent(dbName, tblName, partName, evtType);
        }
        return true;
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.deleteTableColumnStatistics(dbName, tableName, colName);
        }
        return true;
    }

    public List<HiveObjectPrivilege> listPartitionGrantsAll(String dbName, String tableName, String partitionName) {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.listPartitionGrantsAll(dbName, tableName, partitionName);
        }
        return Collections.emptyList();
    }

    public PrincipalPrivilegeSet getPartitionPrivilegeSet(String dbName, String tableName, String partition, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.getPartitionPrivilegeSet(dbName, tableName, partition, userName, groupNames);
        }
        return Empties.privSet();
    }

    public Table markPartitionForEvent(String dbName, String tblName, Map<String, String> partVals, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        if (this.routeToDelegate(Hive2NessieRawStore.route(dbName))) {
            return this.delegate.markPartitionForEvent(dbName, tblName, partVals, evtType);
        }
        throw new IllegalArgumentException("Loud Failure");
    }
}

