/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;

public class EntriesParams {
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="hash")})
    @QueryParam(value="hashOnRef")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String hashOnRef;
    @Parameter(description="maximum number of entries to return, just a hint for the server")
    @QueryParam(value="max")
    private Integer maxRecords;
    @Parameter(description="pagination continuation token, as returned in the previous EntriesResponse.token")
    @QueryParam(value="pageToken")
    private String pageToken;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are 'entry.namespace' (string) & 'entry.contentType' (string)", examples={@ExampleObject(ref="expr_by_namespace"), @ExampleObject(ref="expr_by_contentType"), @ExampleObject(ref="expr_by_namespace_and_contentType")})
    @QueryParam(value="query_expression")
    private String queryExpression;

    public EntriesParams() {
    }

    private EntriesParams(String hashOnRef, Integer maxRecords, String pageToken, String queryExpression) {
        this.hashOnRef = hashOnRef;
        this.maxRecords = maxRecords;
        this.pageToken = pageToken;
        this.queryExpression = queryExpression;
    }

    private EntriesParams(Builder builder) {
        this(builder.hashOnRef, builder.maxRecords, builder.pageToken, builder.queryExpression);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EntriesParams empty() {
        return new Builder().build();
    }

    @Nullable
    public String hashOnRef() {
        return this.hashOnRef;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public String queryExpression() {
        return this.queryExpression;
    }

    public String toString() {
        return new StringJoiner(", ", EntriesParams.class.getSimpleName() + "[", "]").add("hashOnRef='" + this.hashOnRef + "'").add("maxRecords=" + this.maxRecords).add("pageToken='" + this.pageToken + "'").add("queryExpression='" + this.queryExpression + "'").toString();
    }

    public static class Builder {
        private String hashOnRef;
        private Integer maxRecords;
        private String pageToken;
        private String queryExpression;

        private Builder() {
        }

        public Builder hashOnRef(String hashOnRef) {
            this.hashOnRef = hashOnRef;
            return this;
        }

        public Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder expression(String queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder from(EntriesParams params) {
            return this.hashOnRef(params.hashOnRef).maxRecords(params.maxRecords).pageToken(params.pageToken).expression(params.queryExpression);
        }

        private void validate() {
        }

        public EntriesParams build() {
            this.validate();
            return new EntriesParams(this);
        }
    }
}

