/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import com.klarna.hiverunner.HiveRunnerExtension;
import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.util.function.Function;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.client.NessieClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;

@ExtendWith(value={HiveRunnerExtension.class})
public abstract class BaseHiveOps {
    private static final int NESSIE_PORT = Integer.getInteger("quarkus.http.test-port", 19121);
    protected static final String URL = String.format("http://localhost:%d/api/v1", NESSIE_PORT);
    protected static NessieClient client;
    @HiveSQL(files={}, autoStart=false)
    protected HiveShell shell;

    @AfterAll
    static void shutdownClient() {
        if (client != null) {
            client.close();
        }
    }

    protected abstract Function<String, String> configFunction();

    @BeforeEach
    void resetData() throws NessieConflictException, NessieNotFoundException {
        NessieClient client = NessieClient.builder().fromConfig(this.configFunction()).build();
        for (Reference r : client.getTreeApi().getAllReferences()) {
            if (r instanceof Branch) {
                client.getTreeApi().deleteBranch(r.getName(), r.getHash());
                continue;
            }
            client.getTreeApi().deleteTag(r.getName(), r.getHash());
        }
        client.getTreeApi().createReference(Branch.of("main", null));
        this.shell.start();
    }
}

