/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.projectnessie.hms.NessieStoreImpl;
import org.projectnessie.hms.RawStoreWithRef;
import org.projectnessie.hms.RoutingTransactionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRawStore
implements RawStoreWithRef {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected NessieStoreImpl nessie;
    protected RawStore delegate;
    protected boolean hasDelegate;
    protected Configuration conf;
    private RoutingTransactionHandler handler;
    private Set<String> nessieDbs = new HashSet<String>();

    protected BaseRawStore(boolean hasDelegate) {
        this.nessie = new NessieStoreImpl();
        this.hasDelegate = hasDelegate;
        this.handler = new RoutingTransactionHandler(() -> this.nessie, () -> Optional.ofNullable(this.delegate));
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.nessie == null) {
            this.nessie = new NessieStoreImpl();
        }
        this.nessie.setConf(conf);
        if (this.hasDelegate) {
            String whitelistDbs = conf.get("nessie.dbs", "");
            this.nessieDbs = Stream.of(whitelistDbs.split(",")).map(String::trim).filter(s -> s.length() > 0).map(String::toLowerCase).collect(Collectors.toSet());
            if (this.nessieDbs.isEmpty()) {
                this.logger.warn("Using delegating Nessie store but no databases were routed to use Nessie functionality. Please update the {} configuration property in your Hive configuration.", (Object)"nessie.dbs");
            } else {
                this.logger.debug("Configuring a delegating store where the following databases are considered Nessie databases: {}.", this.nessieDbs);
            }
            if (this.delegate == null) {
                this.delegate = new ObjectStore();
            }
            this.delegate.setConf(conf);
        }
    }

    @Override
    public String getRef() {
        return this.nessie.getRef();
    }

    protected static int union(int i, int x) {
        return i + x;
    }

    protected static <T> List<T> union(List<T> a, List<T> b) {
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toList());
    }

    protected static Stream<String> route(Database db) {
        return Stream.of(db.getName());
    }

    protected static Stream<String> route(Table table) {
        return Stream.of(table.getDbName());
    }

    protected static Stream<String> route(Partition partition) {
        return Stream.of(partition.getDbName());
    }

    protected static Stream<String> route(ColumnStatistics s) {
        return Stream.of(s.getStatsDesc().getDbName());
    }

    protected static Stream<String> route(Index i) {
        return Stream.of(i.getDbName());
    }

    protected static Stream<String> route(SQLForeignKey c) {
        return Stream.of(c.getFktable_db(), c.getPktable_db());
    }

    protected static Stream<String> route(SQLPrimaryKey c) {
        return Stream.of(c.getTable_db());
    }

    protected static Stream<String> route(String s) {
        return Stream.of(s);
    }

    private boolean isNessieDb(String name) {
        if ("$nessie".equalsIgnoreCase(name)) {
            return true;
        }
        if ("nessie".equalsIgnoreCase(name)) {
            return true;
        }
        return this.nessieDbs.contains(name.toLowerCase());
    }

    protected boolean routeToDelegate(Stream<String> databases) {
        boolean useDelegate = this.checkRouteToDelegate(databases);
        if (useDelegate) {
            this.handler.routedDelegate();
        } else {
            this.handler.routedNessie();
        }
        return useDelegate;
    }

    private boolean checkRouteToDelegate(Stream<String> databases) {
        if (!this.hasDelegate) {
            return false;
        }
        Set dbs = databases.collect(Collectors.toSet());
        int nessieMatches = 0;
        for (String db : dbs) {
            if (!this.isNessieDb(db)) continue;
            ++nessieMatches;
        }
        if (nessieMatches == 0) {
            return true;
        }
        if (nessieMatches == dbs.size()) {
            return false;
        }
        throw new IllegalArgumentException("You tried to do an operation that referenced both Nessie and Legacy database types. This is not supported.");
    }

    protected void checkHasDelegate() {
        if (!this.hasDelegate) {
            throw new IllegalArgumentException("Nessie does not support this operation.");
        }
    }

    public void shutdown() {
        if (this.nessie != null) {
            this.nessie.shutdown();
        }
        if (this.delegate != null) {
            this.delegate.shutdown();
        }
    }

    public boolean openTransaction() {
        return this.handler.openTransaction();
    }

    public boolean commitTransaction() {
        return this.handler.commitTransaction();
    }

    public boolean isActiveTransaction() {
        return this.handler.isActiveTransaction();
    }

    public void rollbackTransaction() {
        this.handler.rollbackTransaction();
    }

    public List<String> getCatalogs() throws MetaException {
        if (this.hasDelegate) {
            return this.delegate.getCatalogs();
        }
        return Collections.singletonList("hive");
    }

    public String getMetaStoreSchemaVersion() throws MetaException {
        if (this.hasDelegate) {
            return this.delegate.getMetaStoreSchemaVersion();
        }
        return "nessie";
    }

    public String getMetastoreDbUuid() throws MetaException {
        if (this.hasDelegate) {
            return this.delegate.getMetastoreDbUuid();
        }
        return "nessie";
    }
}

