/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.NotBlank;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Merge Operation", properties={@SchemaProperty(name="fromHash", pattern="^[0-9a-fA-F]{16,64}$")})
@JsonSerialize(as=ImmutableMerge.class)
@JsonDeserialize(as=ImmutableMerge.class)
@Value.Immutable(prehash=true)
public interface Merge {
    @NotBlank
    @JsonFormat(pattern="^[0-9a-fA-F]{16,64}$")
    public String getFromHash();

    @Value.Check
    default public void checkHash() {
        String hash = this.getFromHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }
}

