/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import com.klarna.hiverunner.HiveRunnerExtension;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.hms.BaseHiveOps;

@ExtendWith(value={HiveRunnerExtension.class})
public abstract class BaseTableOperations
extends BaseHiveOps {
    @Test
    public void invalidTypes() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.shell.execute("create external table t2 (a int, b int) PARTITIONED BY (c int);")).isInstanceOf(Exception.class)).hasMessageContaining("immutable=true");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.shell.execute("create table t2 (a int, b int) PARTITIONED BY (c int);")).isInstanceOf(Exception.class)).hasMessageContaining("External Tables");
    }

    @Test
    public void insertOnImmutable() {
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        this.shell.execute("insert into t1 PARTITION(c)select 1 as a,1 as b,1 as c union all select 2,2,2 union all select 3,3,3 union all select 4,4,4 ");
        List partitions = this.shell.executeQuery("show partitions t1");
        Assertions.assertThat((List)partitions).containsExactlyInAnyOrder((Object[])new String[]{"c=1", "c=2", "c=3", "c=4"});
        this.shell.execute("alter table t1 drop partition (c=1)");
        List partitions2 = this.shell.executeQuery("show partitions t1");
        Assertions.assertThat((List)partitions2).containsExactlyInAnyOrder((Object[])new String[]{"c=2", "c=3", "c=4"});
        this.shell.execute("drop table t1");
    }

    @Test
    public void changeContext() throws NessieNotFoundException, NessieConflictException {
        String mainOriginalHash = client.getTreeApi().getDefaultBranch().getHash();
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        this.shell.execute("insert into t1 PARTITION(c) select 1 as a,1 as b,1 as c union all select 2,2,2 union all select 3,3,3 union all select 4,4,4 ");
        this.shell.execute(String.format("CREATE VIEW `$nessie`.dev TBLPROPERTIES(\"ref\"=\"%s\") AS SELECT * FROM T1", mainOriginalHash));
        this.shell.execute("alter database `$nessie` set dbproperties (\"ref\"=\"dev\")");
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.shell.executeQuery("select * from `t1`").size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.shell.executeQuery("select * from `t1@main`").size());
        this.shell.execute("alter database `$nessie` set dbproperties (\"ref\"=\"main\")");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)this.shell.executeQuery("select * from `t1`").size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.shell.executeQuery("select * from `t1@dev`").size());
        this.shell.execute("drop table t1");
        this.shell.execute("alter database `$nessie` set dbproperties (\"ref\"=\"dev\")");
        this.shell.execute("drop table t1");
        List items = this.shell.executeQuery("show tables in `$nessie`");
        Assertions.assertThat(Arrays.asList("main", "dev")).containsExactlyInAnyOrderElementsOf((Iterable)items);
    }

    @Test
    public void tableCreateDrop() {
        this.shell.execute("create external table t1 (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\");");
        List records = this.shell.executeStatement("describe t1");
        this.shell.execute("DROP TABLE t1");
    }
}

