/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.api;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;

@Consumes(value={"application/json"})
@Path(value="contents")
public interface ContentsApi {
    @GET
    @Produces(value={"application/json"})
    @Path(value="{key}/{ref}")
    @Operation(summary="Fetch details of a table endpoint")
    @APIResponses(value={@APIResponse(responseCode="200", description="Information for table"), @APIResponse(responseCode="404", description="Table not found on ref")})
    public Contents getContents(@Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Parameter(description="Name of ref to read from. Default branch if not provided.") @PathParam(value="ref") String var2) throws NessieNotFoundException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="{key}")
    @Operation(summary="Fetch details of a table endpoint for default branch")
    @APIResponses(value={@APIResponse(responseCode="200", description="Information for table"), @APIResponse(responseCode="404", description="Table not found on ref")})
    public Contents getContents(@Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1) throws NessieNotFoundException;

    @POST
    @Path(value="{key}/{hash}")
    @Consumes(value={"application/json"})
    @Operation(summary="update contents for path")
    @APIResponses(value={@APIResponse(responseCode="204", description="Contents updated successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Update conflict")})
    public void setContents(@NotNull @Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @NotNull @Parameter(description="Expected hash of branch.") @PathParam(value="hash") String var2, @Parameter(description="Commit message") @QueryParam(value="message") String var3, @NotNull @RequestBody(description="Contents to be upserted") Contents var4) throws NessieNotFoundException, NessieConflictException;

    @POST
    @Path(value="{key}/{branch}/{hash}")
    @Consumes(value={"application/json"})
    @Operation(summary="update contents for path")
    @APIResponses(value={@APIResponse(responseCode="204", description="Contents updated successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Update conflict")})
    public void setContents(@NotNull @Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Parameter(description="Branch to change, defaults to default branch.") @PathParam(value="branch") String var2, @NotNull @Parameter(description="Expected hash of branch.") @PathParam(value="hash") String var3, @Parameter(description="Commit message") @QueryParam(value="message") String var4, @NotNull @RequestBody(description="Contents to be upserted") Contents var5) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="{key}/{hash}")
    @Operation(summary="delete object on ref endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Update conflict")})
    public void deleteContents(@Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Parameter(description="Expected hash of branch.") @PathParam(value="hash") String var2, @Parameter(description="Commit message") @QueryParam(value="message") String var3) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="{key}/{branch}/{hash}")
    @Operation(summary="delete object on ref endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Update conflict")})
    public void deleteContents(@Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Parameter(description="Branch to delete from, defaults to default branch.") @PathParam(value="branch") String var2, @Parameter(description="Expected hash of branch.") @PathParam(value="hash") String var3, @Parameter(description="Commit message") @QueryParam(value="message") String var4) throws NessieNotFoundException, NessieConflictException;
}

