/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client;

import com.dremio.nessie.api.ConfigApi;
import com.dremio.nessie.api.ContentsApi;
import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.client.ClientConfigApi;
import com.dremio.nessie.client.ClientContentsApi;
import com.dremio.nessie.client.ClientTreeApi;
import com.dremio.nessie.client.auth.AuthFilter;
import com.dremio.nessie.client.rest.ObjectMapperContextResolver;
import com.dremio.nessie.client.rest.ResponseCheckFilter;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.ContentsKey;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.function.Function;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;

public class NessieClient
implements Closeable {
    public static final String CONF_NESSIE_URL = "nessie.url";
    public static final String CONF_NESSIE_USERNAME = "nessie.username";
    public static final String CONF_NESSIE_PASSWORD = "nessie.password";
    public static final String CONF_NESSIE_AUTH_TYPE = "nessie.auth_type";
    public static final String NESSIE_AUTH_TYPE_DEFAULT = "BASIC";
    public static final String CONF_NESSIE_REF = "nessie.ref";
    private final Client client = ((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(ObjectMapperContextResolver.class)).register(ResponseCheckFilter.class)).register(ContentsKey.NessieObjectKeyConverterProvider.class)).build();
    private final TreeApi tree;
    private final ConfigApi config;
    private final ContentsApi contents;

    public NessieClient(AuthType authType, String path, String username, String password) {
        WebTarget target = this.client.target(path);
        AuthFilter authFilter = new AuthFilter(authType, username, password, target);
        this.client.register((Object)authFilter);
        this.contents = this.wrap(ContentsApi.class, new ClientContentsApi(target));
        this.tree = this.wrap(TreeApi.class, new ClientTreeApi(target));
        this.config = this.wrap(ConfigApi.class, new ClientConfigApi(target));
    }

    private <T> T wrap(Class<T> iface, T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ExceptionRewriter(delegate));
    }

    public TreeApi getTreeApi() {
        return this.tree;
    }

    public ContentsApi getContentsApi() {
        return this.contents;
    }

    public ConfigApi getConfigApi() {
        return this.config;
    }

    @Override
    public void close() {
        this.client.close();
    }

    public static NessieClient basic(String path, String username, String password) {
        return new NessieClient(AuthType.BASIC, path, username, password);
    }

    public static NessieClient aws(String path) {
        return new NessieClient(AuthType.AWS, path, null, null);
    }

    public static NessieClient none(String path) {
        return new NessieClient(AuthType.NONE, path, null, null);
    }

    public static NessieClient withConfig(Function<String, String> configuration) {
        String url = Objects.requireNonNull(configuration.apply(CONF_NESSIE_URL));
        String authType = configuration.apply(CONF_NESSIE_AUTH_TYPE);
        if (authType == null) {
            authType = NESSIE_AUTH_TYPE_DEFAULT;
        }
        String username = configuration.apply(CONF_NESSIE_USERNAME);
        String password = configuration.apply(CONF_NESSIE_PASSWORD);
        return new NessieClient(AuthType.valueOf(authType), url, username, password);
    }

    static {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    private static class ExceptionRewriter
    implements InvocationHandler {
        private final Object delegate;

        public ExceptionRewriter(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof ResponseProcessingException) {
                    if (targetException.getCause() instanceof NessieNotFoundException) {
                        throw (NessieNotFoundException)targetException.getCause();
                    }
                    if (targetException.getCause() instanceof NessieConflictException) {
                        throw (NessieConflictException)targetException.getCause();
                    }
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
                throw ex;
            }
        }
    }

    public static enum AuthType {
        AWS,
        BASIC,
        NONE;

    }
}

