/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms;

import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Reference;
import com.klarna.hiverunner.HiveRunnerExtension;
import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.util.function.Function;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={HiveRunnerExtension.class})
public abstract class BaseHiveOps {
    protected static final String URL = "http://localhost:19121/api/v1";
    protected static NessieClient client;
    @HiveSQL(files={}, autoStart=false)
    protected HiveShell shell;

    @AfterAll
    static void shutdownClient() {
        if (client != null) {
            client.close();
        }
    }

    protected abstract Function<String, String> configFunction();

    @BeforeEach
    void resetData() throws NessieConflictException, NessieNotFoundException {
        NessieClient client = NessieClient.withConfig(this.configFunction());
        for (Reference r : client.getTreeApi().getAllReferences()) {
            if (r instanceof Branch) {
                client.getTreeApi().deleteBranch(r.getName(), r.getHash());
                continue;
            }
            client.getTreeApi().deleteTag(r.getName(), r.getHash());
        }
        client.getTreeApi().createEmptyBranch("main");
        this.shell.start();
    }
}

