/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms;

import com.dremio.nessie.hms.NessieStoreImpl;
import com.dremio.nessie.hms.RawStoreWithRef;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.metastore.RawStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTraceRawStore
implements RawStore {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTraceRawStore.class);
    private final RawStore delegate;
    private final RawStoreWithRef inner = this.createNewInner();

    public BaseTraceRawStore() {
        this.delegate = (RawStore)Proxy.newProxyInstance(NessieStoreImpl.class.getClassLoader(), new Class[]{RawStore.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (BaseTraceRawStore.this.inner.getRef() != null) {
                    System.out.print(String.format("[%s] ", BaseTraceRawStore.this.inner.getRef()));
                }
                if (args == null) {
                    System.out.print(String.format("%s()", method.getName()));
                } else {
                    System.out.print(String.format("%s(%s)", method.getName(), args.length == 0 ? "" : Stream.of(args).map(o -> o == null ? null : o.toString()).collect(Collectors.joining(", "))));
                }
                try {
                    boolean isNoReturn = method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(Void.class);
                    Object output = method.invoke((Object)BaseTraceRawStore.this.inner, args);
                    if (isNoReturn) {
                        System.out.println(" <no return>");
                    } else {
                        System.out.println(output == null ? " ==> null" : " ==> " + output.toString());
                    }
                    return output;
                }
                catch (InvocationTargetException ex) {
                    System.out.println(String.format(" ==> %s: %s", ex.getCause().getClass().getSimpleName(), ex.getCause().getMessage()));
                    throw ex.getCause();
                }
            }
        });
    }

    protected abstract RawStoreWithRef createNewInner();
}

