/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms;

import com.dremio.nessie.hms.NessieStore;
import com.dremio.nessie.hms.TransactionHandler;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hadoop.hive.metastore.RawStore;

class RoutingTransactionHandler
implements TransactionHandler {
    Supplier<NessieStore> nessie;
    Supplier<Optional<RawStore>> delegate;

    RoutingTransactionHandler(Supplier<NessieStore> nessie, Supplier<Optional<RawStore>> delegate) {
        this.nessie = nessie;
        this.delegate = delegate;
    }

    public void routedDelegate() {
    }

    public void routedNessie() {
    }

    private boolean hasDelegate() {
        return this.delegate.get().isPresent();
    }

    @Override
    public boolean isActiveTransaction() {
        boolean isActive = this.nessie.get().isActiveTransaction();
        if (!this.hasDelegate()) {
            return isActive;
        }
        return this.delegate.get().get().isActiveTransaction() && isActive;
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public boolean openTransaction() {
        boolean ret = this.nessie.get().openTransaction();
        this.delegate.get().ifPresent(r -> r.openTransaction());
        return ret;
    }

    @Override
    public boolean commitTransaction() {
        boolean ret = this.nessie.get().commitTransaction();
        this.delegate.get().ifPresent(r -> r.commitTransaction());
        return ret;
    }

    @Override
    public void shutdown() {
        this.nessie.get().shutdown();
        this.delegate.get().ifPresent(r -> r.shutdown());
    }
}

