/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms.annotation;

import com.dremio.nessie.hms.annotation.CatalogExtend;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class MethodSignature {
    private final SigType type;
    private final Type returnType;
    private final Type[] argumentTypes;
    private final Type[] exceptionTypes;
    private final String name;

    public MethodSignature(Method m) {
        this.returnType = m.getGenericReturnType();
        this.argumentTypes = m.getGenericParameterTypes();
        this.exceptionTypes = m.getGenericExceptionTypes();
        this.name = m.getName();
        this.type = MethodSignature.hasCatalogExtend(m) ? SigType.ORIG_EXTEND : SigType.ORIG;
    }

    private MethodSignature(SigType type, Type returnType, Type[] argumentTypes, Type[] exceptionTypes, String name) {
        this.type = type;
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.exceptionTypes = exceptionTypes;
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.argumentTypes);
        result = 31 * result + Arrays.hashCode(this.exceptionTypes);
        result = 31 * result + Objects.hash(this.name, this.returnType);
        return result;
    }

    private static boolean hasCatalogExtend(Method method) {
        return method.getAnnotation(CatalogExtend.class) != null;
    }

    public Optional<MethodSignature> extendIfNecessary() {
        if (this.type != SigType.ORIG_EXTEND) {
            return Optional.empty();
        }
        Preconditions.checkArgument((this.type == SigType.ORIG_EXTEND ? 1 : 0) != 0);
        Type[] args = new Type[this.argumentTypes.length + 1];
        System.arraycopy(this.argumentTypes, 0, args, 1, this.argumentTypes.length);
        args[0] = String.class;
        return Optional.of(new MethodSignature(SigType.EXTENDED, this.returnType, args, this.exceptionTypes, this.name));
    }

    public boolean isExtended() {
        return this.type == SigType.EXTENDED;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        return Arrays.equals(this.argumentTypes, other.argumentTypes) && Arrays.equals(this.exceptionTypes, other.exceptionTypes) && Objects.equals(this.name, other.name) && Objects.equals(this.returnType, other.returnType);
    }

    public static enum SigType {
        ORIG,
        ORIG_EXTEND,
        EXTENDED;

    }
}

