/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.auth;

import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.client.auth.Auth;
import com.dremio.nessie.client.auth.NoAuth;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;

public class AuthFilter
implements ClientRequestFilter {
    private final Auth auth;

    public AuthFilter(NessieClient.AuthType authType, String username, String password, WebTarget target) {
        switch (authType) {
            case AWS: 
            case NONE: {
                this.auth = new NoAuth();
                break;
            }
            case BASIC: {
                this.auth = new NoAuth();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("%s does not exist", new Object[]{authType}));
            }
        }
    }

    private String checkKey() {
        return this.auth.checkKey();
    }

    public void filter(ClientRequestContext requestContext) {
        String header = this.checkKey();
        if (header != null && !header.isEmpty()) {
            requestContext.getHeaders().putSingle((Object)"Authorization", (Object)header);
        }
    }
}

