/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.core.Response;

public class NessieError {
    private final String message;
    private final Response.Status status;
    private final String serverStackTrace;
    private final Exception clientProcessingException;

    @JsonCreator
    public NessieError(@JsonProperty(value="message") String message, @JsonProperty(value="status") Response.Status status, @JsonProperty(value="serverStackTrace") String serverStackTrace) {
        this(message, status, serverStackTrace, null);
    }

    public NessieError(String message, Response.Status status, String serverStackTrace, Exception processingException) {
        this.message = message;
        this.status = status;
        this.serverStackTrace = serverStackTrace;
        this.clientProcessingException = processingException;
    }

    public String getMessage() {
        return this.message;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public String getServerStackTrace() {
        return this.serverStackTrace;
    }

    @JsonIgnore
    public Exception getClientProcessingException() {
        return this.clientProcessingException;
    }

    @JsonIgnore
    public String getFullMessage() {
        if (this.serverStackTrace != null) {
            return String.format("%s\nStatus Code: %d\nStatus Reason: %s\nServer Stack Trace:\n%s", this.message, this.status.getStatusCode(), this.status.getReasonPhrase(), this.serverStackTrace);
        }
        if (this.clientProcessingException != null) {
            StringWriter sw = new StringWriter();
            this.clientProcessingException.printStackTrace(new PrintWriter(sw));
            return String.format("%s\nStatus Code: %d\nStatus Reason: %s\nClient Processing Failure:\n%s", this.message, this.status.getStatusCode(), this.status.getReasonPhrase(), sw.toString());
        }
        return this.message;
    }
}

