/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms;

import com.dremio.nessie.hms.BaseRawStore;
import com.dremio.nessie.hms.BaseRawStore3;
import com.dremio.nessie.hms.Empties;
import com.dremio.nessie.hms.Hive3EmptyCode;
import com.dremio.nessie.hms.annotation.MethodSignature;
import com.dremio.nessie.hms.annotation.NoopQuiet;
import com.dremio.nessie.hms.annotation.NoopThrow;
import com.dremio.nessie.hms.annotation.Route;
import com.dremio.nessie.hms.annotation.Union;
import com.dremio.nessie.hms.apis.AnnotatedHive2RawStore;
import com.dremio.nessie.hms.apis.AnnotatedHive3RawStore;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import picocli.CommandLine;

@CommandLine.Command(name="generate-hive-raw-store", mixinStandardHelpOptions=true, description={"Generates delegating and non-delegating RawStore implementations for a particular Hive version."})
public class CodeGenerator
implements Callable<Integer> {
    @CommandLine.Option(names={"-m", "--mode"}, required=true, description={"Hive version to generate. Valid values: ${COMPLETION-CANDIDATES}"})
    private HiveVersion version = HiveVersion.HIVE3;
    @CommandLine.Option(names={"-o", "--output"}, required=true, description={"Output path to write to"})
    private String outputPath;

    @Override
    public Integer call() throws Exception {
        TypeSpec.Builder raw = this.version.nonDelegatingBuilder();
        HashMap<MethodSignature, MethodHolder> methods = new HashMap<MethodSignature, MethodHolder>();
        for (Method m : this.version.annotatedInterface.getMethods()) {
            MethodSignature s = new MethodSignature(m);
            methods.put(s, new MethodHolder(m, false));
            s.extendIfNecessary().ifPresent(s2 -> methods.put((MethodSignature)s2, new MethodHolder(m, true)));
        }
        for (Method definedMethod : RawStore.class.getMethods()) {
            MethodSignature signature = new MethodSignature(definedMethod);
            MethodHolder holder = (MethodHolder)methods.get(signature);
            if (holder == null) {
                throw new IllegalStateException("unknown method: " + definedMethod);
            }
            CodeGenerator.generateMethod(this.version, holder, definedMethod).ifPresent(arg_0 -> ((TypeSpec.Builder)raw).addMethod(arg_0));
        }
        raw.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(false)", new Object[0]).build());
        raw.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Boolean.TYPE, "delegate", new Modifier[0]).addStatement("super(delegate)", new Object[0]).build());
        TypeSpec nodelegate = raw.build();
        JavaFile javaFile = JavaFile.builder((String)"org.projectnessie", (TypeSpec)nodelegate).build();
        javaFile.writeTo(new File(this.outputPath));
        TypeSpec.Builder delegating = this.version.delegatingBuilder(nodelegate);
        delegating.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(true)", new Object[0]).build());
        JavaFile javaFile2 = JavaFile.builder((String)"org.projectnessie", (TypeSpec)delegating.build()).build();
        javaFile2.writeTo(new File(this.outputPath));
        return 0;
    }

    private static Optional<MethodSpec> generateMethod(HiveVersion version, MethodHolder holder, Method definedMethod) {
        boolean noAnnotation;
        Parameter p2;
        int i;
        Method boundMethod = holder.method;
        boolean extended = holder.extended();
        NoopQuiet quiet = boundMethod.getAnnotation(NoopQuiet.class);
        NoopThrow loud = boundMethod.getAnnotation(NoopThrow.class);
        Union union = boundMethod.getAnnotation(Union.class);
        List parameters = Stream.of(definedMethod.getParameters()).map(p -> new Param(p.getName(), p.getParameterizedType())).collect(Collectors.toList());
        if (extended) {
            parameters.set(0, new Param("catalogName", ((Param)parameters.get(0)).getType()));
            for (i = 0; i < boundMethod.getParameterCount(); ++i) {
                p2 = boundMethod.getParameters()[i];
                parameters.set(i + 1, new Param(p2.getName(), p2.getParameterizedType()));
            }
        } else {
            for (i = 0; i < boundMethod.getParameterCount(); ++i) {
                p2 = boundMethod.getParameters()[i];
                parameters.set(i, new Param(p2.getName(), p2.getParameterizedType()));
            }
        }
        int argNumber = -1;
        for (int i2 = 0; i2 < boundMethod.getParameterCount(); ++i2) {
            Parameter p3 = boundMethod.getParameters()[i2];
            Route anno = p3.getAnnotation(Route.class);
            if (anno == null) continue;
            if (holder.extended) {
                argNumber = i2 + 1;
                break;
            }
            argNumber = i2;
            break;
        }
        boolean routed = argNumber != -1;
        boolean bl = noAnnotation = quiet == null && loud == null && union == null;
        if (!routed && noAnnotation) {
            return Optional.empty();
        }
        Param param = routed ? (Param)parameters.get(argNumber) : null;
        boolean hasReturn = definedMethod.getGenericReturnType() != Void.TYPE;
        MethodSpec.Builder meth = MethodSpec.methodBuilder((String)definedMethod.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(definedMethod.getGenericReturnType());
        if (routed) {
            meth.addComment("This method is routed based on the database name provided.", new Object[0]);
            if (quiet != null) {
                meth.addComment("If the routing targets nessie, this is a noop.", new Object[0]);
            } else if (loud != null) {
                meth.addComment("If the routing targets nessie, this will throw an exception.", new Object[0]);
            }
        } else {
            meth.addComment("This method uses a delegate if it exists.", new Object[0]);
            if (quiet != null) {
                meth.addComment("If no delegate exists, this method is a noop.", new Object[0]);
            } else if (loud != null) {
                meth.addComment("If no delegate exists, this method will throw an exception.", new Object[0]);
            } else if (union != null) {
                meth.addComment("Union of implementation results is generated.", new Object[0]);
            }
        }
        String returnStr = hasReturn ? "return " : "";
        List nessieList = holder.extended ? parameters.subList(1, parameters.size()) : parameters;
        parameters.stream().forEach(p -> meth.addParameter(p.getType(), p.getName(), new Modifier[0]));
        Stream.of(definedMethod.getGenericExceptionTypes()).forEach(e -> meth.addException(e));
        if (routed) {
            CodeBlock.Builder code = CodeBlock.builder();
            if (param.getType() instanceof ParameterizedType && ((ParameterizedType)param.getType()).getRawType() == List.class) {
                code.beginControlFlow("if (routeToDelegate($L.stream().flatMap($T::route)))", new Object[]{param.getName(), version.baseRawStore});
            } else {
                code.beginControlFlow("if (routeToDelegate(route($L)))", new Object[]{param.getName()});
            }
            code.addStatement("$Ldelegate.$L($L)", new Object[]{returnStr, definedMethod.getName(), parameters.stream().map(Param::getName).collect(Collectors.joining(", "))});
            code.nextControlFlow("else", new Object[0]);
            if (noAnnotation) {
                code.addStatement("$Lnessie.$L($L)", new Object[]{returnStr, definedMethod.getName(), nessieList.stream().map(Param::getName).collect(Collectors.joining(", "))});
            }
            if (quiet != null) {
                CodeGenerator.quietReturn(version, code, quiet, definedMethod.getReturnType());
            } else if (loud != null) {
                code.addStatement("throw new IllegalArgumentException(\"Loud Failure\")", new Object[0]);
            }
            code.endControlFlow();
            meth.addCode(code.build());
        } else if (union == null) {
            if (quiet != null) {
                CodeBlock.Builder code = CodeBlock.builder();
                code.beginControlFlow("if (hasDelegate)", new Object[0]);
                code.addStatement("$Ldelegate.$L($L)", new Object[]{returnStr, definedMethod.getName(), parameters.stream().map(Param::getName).collect(Collectors.joining(", "))});
                code.nextControlFlow("else", new Object[0]);
                CodeGenerator.quietReturn(version, code, quiet, definedMethod.getReturnType());
                code.endControlFlow();
                meth.addCode(code.build());
            } else {
                meth.addStatement("checkHasDelegate()", new Object[0]);
                meth.addStatement("$Ldelegate.$L($L)", new Object[]{returnStr, definedMethod.getName(), parameters.stream().map(Param::getName).collect(Collectors.joining(", "))});
            }
        } else {
            CodeBlock.Builder b = CodeBlock.builder();
            b.beginControlFlow("if (hasDelegate)", new Object[0]);
            b.addStatement("return union(delegate.$L($L), nessie.$L($L))", new Object[]{definedMethod.getName(), parameters.stream().map(Param::getName).collect(Collectors.joining(", ")), definedMethod.getName(), nessieList.stream().map(Param::getName).collect(Collectors.joining(", "))});
            b.nextControlFlow("else", new Object[0]);
            b.addStatement("return nessie.$L($L)", new Object[]{definedMethod.getName(), nessieList.stream().map(Param::getName).collect(Collectors.joining(", "))});
            b.endControlFlow();
            meth.addCode(b.build());
        }
        return Optional.of(meth.build());
    }

    private static void quietReturn(HiveVersion version, CodeBlock.Builder code, NoopQuiet quiet, Class<?> returnType) {
        if (returnType != Void.TYPE) {
            if (quiet.value() == NoopQuiet.QuietMode.NULL) {
                code.addStatement("return null", new Object[0]);
            } else if (returnType == List.class) {
                code.addStatement("return $T.emptyList()", new Object[]{Collections.class});
            } else if (returnType == Long.TYPE) {
                code.addStatement("return 0L", new Object[0]);
            } else if (returnType == Boolean.TYPE) {
                code.addStatement("return true", new Object[0]);
            } else if (returnType == PrincipalPrivilegeSet.class) {
                code.addStatement("return $T.privSet()", new Object[]{Empties.class});
            } else if (returnType == ColumnStatistics.class) {
                code.addStatement("return $T.colStats()", new Object[]{Empties.class});
            } else if (returnType == Integer.TYPE) {
                code.addStatement("return 0", new Object[0]);
            } else if (returnType == String[].class) {
                code.addStatement("return new String[0]", new Object[0]);
            } else if (returnType == NotificationEventResponse.class) {
                code.addStatement("return $T.event()", new Object[]{Empties.class});
            } else if (returnType == CurrentNotificationEventId.class) {
                code.addStatement("return $T.eventId()", new Object[]{Empties.class});
            } else if (!version.quietReturn.quietReturn(code, returnType)) {
                code.addStatement("return EMPTY", new Object[0]);
            }
        } else {
            code.addStatement("return", new Object[0]);
        }
    }

    public static void main(String ... args) {
        int exitCode = new CommandLine((Object)new CodeGenerator()).execute(args);
        System.exit(exitCode);
    }

    private static class MethodHolder {
        private final Method method;
        private final boolean extended;

        public MethodHolder(Method method, boolean extended) {
            this.method = method;
            this.extended = extended;
        }

        boolean extended() {
            return this.extended;
        }
    }

    private static class Param {
        private final String name;
        private final Type type;

        public Param(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum HiveVersion {
        HIVE2("Hive2", AnnotatedHive2RawStore.class, (a, b) -> false, BaseRawStore.class),
        HIVE3("Hive3", AnnotatedHive3RawStore.class, Hive3EmptyCode::quietReturn, BaseRawStore3.class);

        private final String prefix;
        private final Class<?> annotatedInterface;
        private final QuietReturn quietReturn;
        private final Class<? extends BaseRawStore> baseRawStore;

        private HiveVersion(String classPrefix, Class<?> annotatedInterface, QuietReturn quietReturn, Class<? extends BaseRawStore> baseRawStore) {
            this.prefix = classPrefix;
            this.annotatedInterface = annotatedInterface;
            this.quietReturn = quietReturn;
            this.baseRawStore = baseRawStore;
        }

        public TypeSpec.Builder nonDelegatingBuilder() {
            return TypeSpec.classBuilder((String)(this.prefix + "NessieRawStore")).superclass(this.baseRawStore).addModifiers(new Modifier[]{Modifier.PUBLIC});
        }

        public TypeSpec.Builder delegatingBuilder(TypeSpec nodelegate) {
            return TypeSpec.classBuilder((String)("Delegating" + this.prefix + "NessieRawStore")).superclass((TypeName)ClassName.bestGuess((String)nodelegate.name)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
    }

    private static interface QuietReturn {
        public boolean quietReturn(CodeBlock.Builder var1, Class<?> var2);
    }
}

