/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms;

import com.dremio.nessie.hms.PartitionFilterer;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive3PartitionFilterer
implements PartitionFilterer.PartitionFiltererImpl {
    private static Logger LOG = LoggerFactory.getLogger(Hive3PartitionFilterer.class);

    @Override
    public boolean filterPartitionsByExpr(Configuration conf, List<FieldSchema> partColumns, byte[] expr, List<String> partitionNames) throws MetaException {
        String defaultPartName = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
        PartitionExpressionProxy pems = Hive3PartitionFilterer.createExpressionProxy(conf);
        return pems.filterPartitionsByExpr(partColumns, expr, defaultPartName, partitionNames);
    }

    private static PartitionExpressionProxy createExpressionProxy(Configuration conf) {
        String className = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS);
        try {
            Class clazz = JavaUtils.getClass((String)className, PartitionExpressionProxy.class);
            return (PartitionExpressionProxy)JavaUtils.newInstance((Class)clazz, (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (MetaException e) {
            LOG.error("Error loading PartitionExpressionProxy", (Throwable)e);
            throw new RuntimeException("Error loading PartitionExpressionProxy: " + e.getMessage());
        }
    }
}

