/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.hms;

import com.dremio.nessie.hms.Item;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.HiveTable;
import com.dremio.nessie.model.ImmutableHiveTable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

class TableW
extends Item {
    private final Table table;
    private final List<Partition> partitions;

    public TableW(Table table, List<Partition> partitions) {
        this.table = table;
        this.partitions = ImmutableList.copyOf(partitions);
    }

    @Override
    public Item.Type getType() {
        return Item.Type.TABLE;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public static TableW fromContents(Contents c) {
        if (!(c instanceof HiveTable)) {
            throw new RuntimeException("Not a Hive table.");
        }
        HiveTable ht = (HiveTable)c;
        return Item.wrap(TableW.fromBytes(new Table(), ht.getTableDefinition()), ht.getPartitions().stream().map(p -> TableW.fromBytes(new Partition(), p)).collect(Collectors.toList()));
    }

    @Override
    public Contents toContents() {
        return ImmutableHiveTable.builder().tableDefinition(TableW.toBytes(this.table)).addAllPartitions(this.getPartitions().stream().map(Item::toBytes).collect(Collectors.toList())).build();
    }
}

