/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

public class ContentsKey {
    private static final char ZERO_BYTE = '\u0000';
    private static final String ZERO_BYTE_STRING = Character.toString('\u0000');
    private final List<String> elements;

    @JsonCreator
    public ContentsKey(@JsonProperty(value="elements") List<String> elements) {
        this.elements = Collections.unmodifiableList(new ArrayList<String>(elements));
        this.validate();
    }

    private ContentsKey(List<String> elements, boolean dummy) {
        this.elements = Collections.unmodifiableList(elements);
        this.validate();
    }

    public static ContentsKey of(String ... elements) {
        return new ContentsKey(Arrays.asList(elements), true);
    }

    public static ContentsKey of(List<String> elements) {
        return new ContentsKey(elements);
    }

    public List<String> getElements() {
        return this.elements;
    }

    private void validate() {
        for (String e : this.elements) {
            if (!e.contains(ZERO_BYTE_STRING)) continue;
            throw new IllegalArgumentException("A object key cannot contain a zero byte.");
        }
    }

    public static ContentsKey fromEncoded(String encoded) {
        List<String> elements = StreamSupport.stream(Arrays.spliterator(encoded.split("\\.")), false).map(x -> x.replace('\u0000', '.')).collect(Collectors.toList());
        return new ContentsKey(elements, true);
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContentsKey)) {
            return false;
        }
        ContentsKey other = (ContentsKey)obj;
        return Objects.equals(this.elements, other.elements);
    }

    public String toString() {
        return this.elements.stream().collect(Collectors.joining("."));
    }

    public String toPathString() {
        String pathString = this.getElements().stream().map(x -> x.replace('.', '\u0000')).collect(Collectors.joining("."));
        return pathString;
    }

    @Provider
    public static class NessieObjectKeyConverterProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType.equals(ContentsKey.class)) {
                return new NessieObjectKeyConverter();
            }
            return null;
        }
    }

    private static class NessieObjectKeyConverter
    implements ParamConverter<ContentsKey> {
        private NessieObjectKeyConverter() {
        }

        public ContentsKey fromString(String value) {
            if (value == null) {
                return null;
            }
            return ContentsKey.fromEncoded(value);
        }

        public String toString(ContentsKey value) {
            if (value == null) {
                return null;
            }
            return value.toPathString();
        }
    }
}

