/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.dremio.nessie.model.CommitMeta;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitMeta", generator="Immutables")
@Immutable
public final class ImmutableCommitMeta
extends CommitMeta {
    @Nullable
    private final String hash;
    private final String commiter;
    @Nullable
    private final String email;
    private final String message;
    @Nullable
    private final Long commitTime;
    private final transient int hashCode;

    private ImmutableCommitMeta(@Nullable String hash, String commiter, @Nullable String email, String message, @Nullable Long commitTime) {
        this.hash = hash;
        this.commiter = commiter;
        this.email = email;
        this.message = message;
        this.commitTime = commitTime;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="commiter")
    public String getCommiter() {
        return this.commiter;
    }

    @Override
    @JsonProperty(value="email")
    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="commitTime")
    @Nullable
    public Long getCommitTime() {
        return this.commitTime;
    }

    public final ImmutableCommitMeta withHash(@Nullable String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return new ImmutableCommitMeta(value, this.commiter, this.email, this.message, this.commitTime);
    }

    public final ImmutableCommitMeta withCommiter(String value) {
        String newValue = Objects.requireNonNull(value, "commiter");
        if (this.commiter.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, newValue, this.email, this.message, this.commitTime);
    }

    public final ImmutableCommitMeta withEmail(@Nullable String value) {
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.commiter, value, this.message, this.commitTime);
    }

    public final ImmutableCommitMeta withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.commiter, this.email, newValue, this.commitTime);
    }

    public final ImmutableCommitMeta withCommitTime(@Nullable Long value) {
        if (Objects.equals(this.commitTime, value)) {
            return this;
        }
        return new ImmutableCommitMeta(this.hash, this.commiter, this.email, this.message, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitMeta && this.equalTo((ImmutableCommitMeta)another);
    }

    private boolean equalTo(ImmutableCommitMeta another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.hash, another.hash) && this.commiter.equals(another.commiter) && Objects.equals(this.email, another.email) && this.message.equals(another.message) && Objects.equals(this.commitTime, another.commitTime);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + this.commiter.hashCode();
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.commitTime);
        return h;
    }

    public String toString() {
        return "CommitMeta{hash=" + this.hash + ", commiter=" + this.commiter + ", email=" + this.email + ", message=" + this.message + ", commitTime=" + this.commitTime + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitMeta fromJson(Json json) {
        Builder builder = ImmutableCommitMeta.builder();
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.commiter != null) {
            builder.commiter(json.commiter);
        }
        if (json.email != null) {
            builder.email(json.email);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.commitTime != null) {
            builder.commitTime(json.commitTime);
        }
        return builder.build();
    }

    public static ImmutableCommitMeta copyOf(CommitMeta instance) {
        if (instance instanceof ImmutableCommitMeta) {
            return (ImmutableCommitMeta)instance;
        }
        return ImmutableCommitMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMITER = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private String hash;
        @Nullable
        private String commiter;
        @Nullable
        private String email;
        @Nullable
        private String message;
        @Nullable
        private Long commitTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitMeta instance) {
            Objects.requireNonNull(instance, "instance");
            String hashValue = instance.getHash();
            if (hashValue != null) {
                this.hash(hashValue);
            }
            this.commiter(instance.getCommiter());
            String emailValue = instance.getEmail();
            if (emailValue != null) {
                this.email(emailValue);
            }
            this.message(instance.getMessage());
            Long commitTimeValue = instance.getCommitTime();
            if (commitTimeValue != null) {
                this.commitTime(commitTimeValue);
            }
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="commiter")
        @CanIgnoreReturnValue
        public final Builder commiter(String commiter) {
            this.commiter = Objects.requireNonNull(commiter, "commiter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="email")
        @CanIgnoreReturnValue
        public final Builder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        @JsonProperty(value="message")
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="commitTime")
        @CanIgnoreReturnValue
        public final Builder commitTime(@Nullable Long commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        public ImmutableCommitMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitMeta(this.hash, this.commiter, this.email, this.message, this.commitTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commiter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build CommitMeta, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitMeta", generator="Immutables")
    static final class Json
    extends CommitMeta {
        @Nullable
        String hash;
        @Nullable
        String commiter;
        @Nullable
        String email;
        @Nullable
        String message;
        @Nullable
        Long commitTime;

        Json() {
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="commiter")
        public void setCommiter(String commiter) {
            this.commiter = commiter;
        }

        @JsonProperty(value="email")
        public void setEmail(@Nullable String email) {
            this.email = email;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="commitTime")
        public void setCommitTime(@Nullable Long commitTime) {
            this.commitTime = commitTime;
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommiter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getCommitTime() {
            throw new UnsupportedOperationException();
        }
    }
}

