/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseContext;

public class HttpResponse {
    private final ResponseContext responseContext;
    private final ObjectMapper mapper;

    HttpResponse(ResponseContext context, ObjectMapper mapper) {
        this.responseContext = context;
        this.mapper = mapper;
    }

    private <V> V readEntity(ObjectReader reader) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = this.responseContext.getInputStream();){
                return (V)reader.readValue(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new HttpClientException("Cannot parse request.", e);
        }
    }

    public <V> V readEntity(Class<V> clazz) {
        return this.readEntity(this.mapper.readerFor(clazz));
    }

    public <V> V readEntity(TypeReference<V> clazz) {
        return this.readEntity(this.mapper.readerFor(clazz));
    }
}

