/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieForbiddenException;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieNotFoundException;

public class ResponseCheckFilter {
    public static void checkResponse(ResponseContext con, ObjectMapper mapper) throws IOException {
        NessieError error;
        Status status = con.getResponseCode();
        if (status.getCode() > 199 && status.getCode() < 300) {
            return;
        }
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream is = con.getErrorStream();){
            error = ResponseCheckFilter.decodeErrorObject(status, is, mapper.readerFor(NessieError.class));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        switch (status) {
            case BAD_REQUEST: {
                throw new NessieBadRequestException(error);
            }
            case UNAUTHORIZED: {
                throw new NessieNotAuthorizedException(error);
            }
            case FORBIDDEN: {
                throw new NessieForbiddenException(error);
            }
            case NOT_FOUND: {
                throw new NessieNotFoundException(error);
            }
            case CONFLICT: {
                throw new NessieConflictException(error);
            }
            case INTERNAL_SERVER_ERROR: {
                throw new NessieInternalServerException(error);
            }
        }
        throw new NessieServiceException(error);
    }

    private static NessieError decodeErrorObject(Status status, InputStream inputStream, ObjectReader reader) {
        NessieError error;
        if (inputStream == null) {
            error = new NessieError(status.getCode(), status.getReason(), "Could not parse error object in response.", new RuntimeException("Could not parse error object in response."));
        } else {
            try {
                error = (NessieError)reader.readValue(inputStream);
            }
            catch (IOException e) {
                error = new NessieError(status.getCode(), status.getReason(), null, e);
            }
        }
        return error;
    }
}

