/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.hms.Item;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableEntry;
import org.projectnessie.model.ImmutableMultiGetContentsRequest;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.MultiGetContentsResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

class TransactionStore {
    private final Reference reference;
    private final TreeApi tree;
    private final ContentsApi contents;
    private final Map<RefKey, Item> cachedItems = new HashMap<RefKey, Item>();
    private final List<Operation> operations = new ArrayList<Operation>();
    private final boolean writable;

    public TransactionStore(Reference reference, ContentsApi contents, TreeApi tree) {
        this.contents = contents;
        this.reference = reference;
        this.writable = reference instanceof Branch;
        this.tree = tree;
    }

    Optional<Item> getItemForRef(String ref, ContentsKey contentsKey) throws NoSuchObjectException {
        RefKey key = new RefKey(ref, contentsKey);
        if (this.cachedItems.containsKey(key)) {
            return Optional.ofNullable(this.cachedItems.get(key));
        }
        try {
            Item item = Item.fromContents(this.contents.getContents(contentsKey, ref));
            this.cachedItems.put(key, item);
            return Optional.ofNullable(item);
        }
        catch (NessieNotFoundException e) {
            throw new NoSuchObjectException(String.format("Unable to find ref [%s].", ref));
        }
    }

    List<Optional<Item>> getItemsForRef(List<RefKey> refKeys) throws NessieNotFoundException {
        ArrayList<Optional<Item>> items = new ArrayList<Optional<Item>>();
        HashMap<RefKey, Integer> keyToPos = new HashMap<RefKey, Integer>();
        ArrayList<RefKey> refKeysToRetrieve = new ArrayList<RefKey>();
        int i = 0;
        while (i < refKeys.size()) {
            RefKey key = refKeys.get(i);
            keyToPos.put(key, i);
            if (this.cachedItems.containsKey(key)) {
                items.set(i, Optional.ofNullable(this.cachedItems.get(key)));
            } else {
                items.set(i, Optional.empty());
                refKeysToRetrieve.add(key);
            }
            ++i;
        }
        ImmutableListMultimap keysByRef = Multimaps.index(refKeysToRetrieve, RefKey::getRef);
        for (String ref : keysByRef.keySet()) {
            List keys = keysByRef.get((Object)ref).stream().map(RefKey::getKey).collect(Collectors.toList());
            MultiGetContentsResponse response = this.contents.getMultipleContents(ref, ImmutableMultiGetContentsRequest.builder().addAllRequestedKeys(keys).build());
            response.getContents().forEach(cwk -> {
                RefKey key = new RefKey(ref, cwk.getKey());
                items.set((Integer)keyToPos.get(key), Optional.of(Item.fromContents(cwk.getContents())));
            });
        }
        return items;
    }

    public List<Reference> getReferences() {
        return this.tree.getAllReferences();
    }

    public Stream<EntriesResponse.Entry> getEntriesForDefaultRef() throws NessieNotFoundException {
        List<EntriesResponse.Entry> entries = this.tree.getEntries(this.reference.getHash()).getEntries();
        Supplier<Stream> defaultRefKeys = () -> this.cachedItems.keySet().stream().filter(k -> k.getRef().equals(this.reference.getHash()));
        Set toRemove = defaultRefKeys.get().map(RefKey::getKey).collect(Collectors.toSet());
        return Stream.concat(entries.stream().filter(k -> !toRemove.contains(k.getName())), defaultRefKeys.get().map(r -> ImmutableEntry.builder().name(r.getKey()).type(Contents.Type.UNKNOWN).build()));
    }

    void setItem(ContentsKey key, Item item) {
        this.checkWritable();
        this.cachedItems.put(new RefKey(this.reference.getHash(), key), item);
        this.operations.add(Operation.Put.of(key, item.toContents()));
    }

    void commit() throws NessieNotFoundException, NessieConflictException {
        if (this.operations.isEmpty()) {
            return;
        }
        this.checkWritable();
        this.tree.commitMultipleOperations(this.reference.getName(), this.reference.getHash(), "HMS commit", ImmutableOperations.builder().addAllOperations(this.operations.stream().collect(Collectors.toList())).build());
    }

    void deleteItem(ContentsKey key) {
        this.checkWritable();
        this.cachedItems.put(new RefKey(this.reference.getHash(), key), null);
        this.operations.add(Operation.Delete.of(key));
    }

    private void checkWritable() {
        if (!this.writable) {
            throw new IllegalArgumentException("Changes can only be applied to branches. The provided ref is not a branch.");
        }
    }

    public static class RefKey {
        private final String ref;
        private final ContentsKey key;

        public RefKey(String ref, ContentsKey key) {
            this.ref = ref;
            this.key = key;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.ref);
        }

        public String getRef() {
            return this.ref;
        }

        public ContentsKey getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RefKey)) {
                return false;
            }
            RefKey other = (RefKey)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.ref, other.ref);
        }
    }
}

