/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.projectnessie.hms.DatabaseW;
import org.projectnessie.hms.TableW;
import org.projectnessie.model.Contents;
import org.projectnessie.model.HiveDatabase;
import org.projectnessie.model.HiveTable;

abstract class Item {
    Item() {
    }

    public abstract Type getType();

    public abstract Contents toContents();

    public Table getTable() {
        throw new IllegalArgumentException("Not a table.");
    }

    public List<Partition> getPartitions() {
        throw new IllegalArgumentException("Not a table.");
    }

    public Database getDatabase() {
        throw new IllegalArgumentException("Not a database.");
    }

    static DatabaseW wrap(Database database) {
        return new DatabaseW(database);
    }

    static TableW wrap(Table table, List<Partition> partitions) {
        return new TableW(table, partitions);
    }

    static Item fromContents(Contents c) {
        if (c instanceof HiveTable) {
            return TableW.fromContents(c);
        }
        if (c instanceof HiveDatabase) {
            return DatabaseW.fromContents(c);
        }
        throw new RuntimeException("Unable to convert to known value.");
    }

    static byte[] toBytes(TBase<?, ?> base) {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            return serializer.serialize(base);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    static <T extends TBase<T, ?>> T fromBytes(T empty, byte[] bytes) {
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        try {
            deserializer.deserialize(empty, bytes);
            return empty;
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Type {
        CATALOG,
        DATABASE,
        TABLE;

    }
}

