/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.thrift.TException;
import org.projectnessie.client.NessieClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.hms.NessieStore;
import org.projectnessie.hms.NessieTransaction;
import org.projectnessie.hms.PartitionFilterer;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieStoreImpl
implements NessieStore {
    private static Logger LOG = LoggerFactory.getLogger(NessieStoreImpl.class);
    private static final String NESSIE_DB = "$nessie";
    private Configuration conf;
    private NessieClient client;
    private String ref;
    private NessieTransaction transaction;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.client = NessieClient.builder().fromConfig(arg_0 -> ((Configuration)conf).get(arg_0)).build();
        try {
            this.ref = this.client.getTreeApi().getDefaultBranch().getName();
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException("Unable to retrieve default branch.", e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    String getRef() {
        return this.ref;
    }

    @Override
    public void shutdown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public boolean openTransaction() {
        if (this.transaction == null) {
            this.transaction = new NessieTransaction(this.ref, this.client, this::clearTransaction);
            return true;
        }
        this.tx().nestedOpen();
        return false;
    }

    @Override
    public boolean commitTransaction() {
        return this.tx().commit();
    }

    private NessieTransaction tx() {
        Preconditions.checkArgument((this.transaction != null ? 1 : 0) != 0, (Object)"Transaction not currently active.");
        return this.transaction;
    }

    private NessieTransaction.Handle txo() {
        if (this.transaction == null) {
            this.transaction = new NessieTransaction(this.ref, this.client, this::clearTransaction);
            return this.transaction.handle();
        }
        return this.transaction.start();
    }

    private void clearTransaction() {
        this.transaction = null;
    }

    @Override
    public boolean isActiveTransaction() {
        return this.transaction != null;
    }

    @Override
    public void rollbackTransaction() {
        this.tx().rollback();
    }

    @Override
    public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            this.tx().createDatabase(db);
        }
    }

    private Database getNessieDb() {
        Database db = new Database();
        try {
            db.setCatalogName("hive");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        db.setName(NESSIE_DB);
        db.setDescription(this.ref);
        return db;
    }

    @Override
    public Database getDatabase(String name) throws NoSuchObjectException {
        if (this.isNessie(name)) {
            return this.getNessieDb();
        }
        try (NessieTransaction.Handle h = this.txo();){
            Database database = this.tx().getDatabase(name).orElseThrow(() -> new NoSuchObjectException());
            return database;
        }
    }

    @Override
    public boolean dropDatabase(String dbname) throws NoSuchObjectException, MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            this.tx().deleteDatabase(dbname);
            boolean bl = true;
            return bl;
        }
    }

    private boolean handleNessieDb(Database db) throws MetaException {
        String refProvided = (String)db.getParameters().get("ref");
        new NessieTransaction(db.getLocationUri(), this.client, this::clearTransaction);
        if (refProvided == null) {
            try {
                this.ref = this.client.getTreeApi().getDefaultBranch().getName();
                return true;
            }
            catch (NessieNotFoundException e) {
                throw new MetaException("Failure while trying to reset to default branch. Default branch does not exist on Nessie.");
            }
        }
        new NessieTransaction(refProvided, this.client, this::clearTransaction);
        this.ref = refProvided;
        return true;
    }

    @Override
    public boolean alterDatabase(String dbname, Database db) throws NoSuchObjectException, MetaException {
        if (dbname.equalsIgnoreCase(NESSIE_DB)) {
            return this.handleNessieDb(db);
        }
        try (NessieTransaction.Handle h = this.txo();){
            this.tx().alterDatabase(db);
        }
        return true;
    }

    @Override
    public List<String> getDatabases(String pattern) throws MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            List<String> list = this.tx().getDatabases().collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<String> getAllDatabases() throws MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            List<String> list = this.tx().getDatabases().collect(Collectors.toList());
            return list;
        }
    }

    private void createBranchOrTag(Table tbl) throws MetaException {
        String tblName = tbl.getTableName();
        if (!tbl.getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new MetaException("Branches/tags can be made only by creating a pseudo-view when using HiveQL. For example CREATE VIEW v1 DBPROPERTIES(\"type\"=\"branch\", \"ref\"=\"abcd...\") as SELECT 1");
        }
        Reference requestedReference = null;
        try {
            String ref = (String)tbl.getParameters().get("ref");
            if (ref != null) {
                requestedReference = this.client.getTreeApi().getReferenceByName(ref);
            }
        }
        catch (NessieNotFoundException ex) {
            throw new MetaException(String.format("The requested Nessie reference [%s] does not exist.", this.ref));
        }
        String type = (String)tbl.getParameters().get("type");
        boolean branch = true;
        if (type != null && !type.equalsIgnoreCase("branch")) {
            if (type.equalsIgnoreCase("tag")) {
                branch = false;
            } else {
                throw new MetaException("Invalid Nessie object type. Expected 'tag' or 'branch' or nothing.");
            }
        }
        try {
            Reference reference = branch ? Branch.of(tblName, requestedReference.getHash()) : Tag.of(tblName, requestedReference.getHash());
            this.client.getTreeApi().createReference(reference);
        }
        catch (NessieNotFoundException e) {
            throw new MetaException("Cannot find the defined reference.");
        }
        catch (NessieConflictException e) {
            throw new MetaException("Cannot create provided branch or tag, one with that name already exists.");
        }
    }

    @Override
    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        if (this.isNessie(tbl.getDbName())) {
            this.createBranchOrTag(tbl);
            return;
        }
        this.checkTableProperties(tbl);
        tbl.getSd().setLocation(tbl.getSd().getLocation() + "/" + UUID.randomUUID().toString());
        try (NessieTransaction.Handle h = this.txo();){
            this.tx().createTable(tbl);
        }
    }

    private void checkTableProperties(Table tbl) throws MetaException {
        boolean isExternalTable = TableType.EXTERNAL_TABLE.name().equals(tbl.getTableType());
        if (!isExternalTable && !TableType.VIRTUAL_VIEW.name().equals(tbl.getTableType())) {
            throw new MetaException("Nessie only supports storing External Tables and Virtual Views. This ensures Hive doesn't delete historical data from valid branches and/or tags.");
        }
        if (isExternalTable && "true".equals(tbl.getParameters().getOrDefault("immutable", "false"))) {
            return;
        }
        throw new MetaException(String.format("Nessie only supports tables that carry the 'immutable=true' property. This allows partition add/removal but disallows operations that skip the metastore.", new Object[0]));
    }

    @Override
    public boolean dropTable(String dbName, String tableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        try (NessieTransaction.Handle h = this.txo();){
            this.tx().deleteTable(dbName, tableName);
            boolean bl = true;
            return bl;
        }
    }

    private Table getNessieTable(String tableName) {
        Reference hash;
        try {
            hash = this.client.getTreeApi().getReferenceByName(tableName);
        }
        catch (NessieNotFoundException e) {
            return null;
        }
        Table t = new Table();
        t.setCatName("hive");
        t.setDbName(NESSIE_DB);
        t.setTableName(tableName);
        t.setOwner(NESSIE_DB);
        t.setPartitionKeys((List)ImmutableList.of());
        t.setSd(new StorageDescriptor());
        t.getSd().setInputFormat("Nessie input format.");
        t.setParameters((Map)ImmutableMap.of((Object)"hash", (Object)hash.getHash()));
        t.setPrivileges(new PrincipalPrivilegeSet());
        t.setRewriteEnabled(false);
        t.setTableType(TableType.EXTERNAL_TABLE.name());
        t.setTemporary(false);
        return t;
    }

    @Override
    public Table getTable(String dbName, String tableName) throws MetaException {
        if (this.isNessie(dbName)) {
            return this.getNessieTable(tableName);
        }
        try (NessieTransaction.Handle h = this.txo();){
            Table table = this.tx().getTableOnly(dbName, tableName);
            return table;
        }
    }

    private boolean isNessie(String dbName) {
        return dbName.equalsIgnoreCase(NESSIE_DB);
    }

    @Override
    public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
        return this.addPartitions(part.getDbName(), part.getTableName(), (List<Partition>)ImmutableList.of((Object)part));
    }

    @Override
    public boolean addPartitions(String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            Optional<NessieTransaction.TableAndPartition> table;
            try {
                table = this.tx().getTable(parts.get(0).getDbName(), parts.get(0).getTableName());
            }
            catch (NoSuchObjectException e) {
                throw new InvalidObjectException(String.format("Unable to find table [%s.%s] for partitions.", parts.get(0).getDbName(), parts.get(0).getTableName()));
            }
            if (!table.isPresent()) {
                throw new InvalidObjectException();
            }
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            partitions.addAll(table.get().getPartitions());
            partitions.addAll(parts);
            this.tx().save(new NessieTransaction.TableAndPartition(table.get().getTable(), partitions));
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean addPartitions(String dbName, String tblName, PartitionSpecProxy partitionSpec, boolean ifNotExists) throws InvalidObjectException, MetaException {
        return this.addPartitions(dbName, tblName, StreamSupport.stream(Spliterators.spliteratorUnknownSize(partitionSpec.getPartitionIterator(), 0), false).collect(Collectors.toList()));
    }

    @Override
    public Partition getPartition(String dbName, String tableName, List<String> partitionValues) throws MetaException, NoSuchObjectException {
        try (NessieTransaction.Handle h = this.txo();){
            Partition partition = this.tx().getPartitions(dbName, tableName).stream().filter(p -> p.getValues().equals(partitionValues)).findFirst().orElseThrow(() -> new NoSuchObjectException());
            return partition;
        }
    }

    @Override
    public Partition getPartitionWithAuth(String dbName, String tblName, List<String> partVals, String userName, List<String> groupNames) throws MetaException, NoSuchObjectException, InvalidObjectException {
        return this.getPartition(dbName, tblName, partVals);
    }

    @Override
    public List<Partition> getPartitionsWithAuth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws MetaException, NoSuchObjectException, InvalidObjectException {
        return this.getPartitions(dbName, tblName, maxParts);
    }

    @Override
    public boolean doesPartitionExist(String dbName, String tableName, List<String> partitionValues) throws MetaException, NoSuchObjectException {
        try (NessieTransaction.Handle h = this.txo();){
            boolean bl = this.tx().getPartitions(dbName, tableName).stream().filter(p -> p.getValues().equals(partitionValues)).findFirst().isPresent();
            return bl;
        }
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, List<String> partVals) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        try (NessieTransaction.Handle h = this.txo();){
            Optional<NessieTransaction.TableAndPartition> tandp = this.tx().getTable(dbName, tableName);
            if (!tandp.isPresent()) {
                throw new NoSuchObjectException();
            }
            ArrayList<Partition> newPartitions = new ArrayList<Partition>();
            boolean found = false;
            for (Partition p : tandp.get().getPartitions()) {
                if (p.getValues().equals(partVals)) {
                    found = true;
                    continue;
                }
                newPartitions.add(p);
            }
            if (!found) {
                throw new InvalidObjectException();
            }
            this.tx().save(new NessieTransaction.TableAndPartition(tandp.get().getTable(), newPartitions));
        }
        return true;
    }

    @Override
    public void dropPartitions(String dbName, String tableName, List<String> partNames) throws MetaException, NoSuchObjectException {
        try (NessieTransaction.Handle h = this.txo();){
            NessieTransaction.TableAndPartition tandp = this.tx().getTable(dbName, tableName).orElseThrow(() -> new NoSuchObjectException());
            ArrayList<Partition> newPartitions = new ArrayList<Partition>();
            HashSet<String> dropNames = new HashSet<String>(partNames);
            for (Partition p : tandp.getPartitions()) {
                String partName = Warehouse.makePartName((List)tandp.getTable().getPartitionKeys(), (List)p.getValues());
                if (dropNames.contains(partName)) continue;
                newPartitions.add(p);
            }
            this.tx().save(new NessieTransaction.TableAndPartition(tandp.getTable(), newPartitions));
        }
    }

    @Override
    public List<Partition> getPartitions(String dbName, String tableName, int max) throws MetaException, NoSuchObjectException {
        try (NessieTransaction.Handle h = this.txo();){
            List<Partition> list = this.tx().getPartitions(dbName, tableName).stream().limit(max == -1 ? Integer.MAX_VALUE : (long)max).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void alterTable(String dbname, String name, Table newTable) throws InvalidObjectException, MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            Table table = this.tx().getTableOnly(dbname, name);
            if (table == null) {
                throw new InvalidObjectException();
            }
            this.checkTableProperties(newTable);
            this.tx().alterTable(newTable);
        }
        catch (NoSuchObjectException e) {
            throw new InvalidObjectException();
        }
    }

    @Override
    public List<String> getTables(String dbName, String pattern) throws MetaException {
        if (this.isNessie(dbName)) {
            return this.client.getTreeApi().getAllReferences().stream().map(nr -> nr.getName()).collect(Collectors.toList());
        }
        try (NessieTransaction.Handle h = this.txo();){
            List<String> list = this.tx().getTables(dbName).map(k -> k.getElements().get(1)).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<String> getTables(String dbName, String pattern, TableType tableType) throws MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            List<String> list = this.tx().getTables(dbName).map(k -> k.getElements().get(1)).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<TableMeta> getTableMeta(String dbName, String tableNames, List<String> tableTypes) throws MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            List<TableMeta> list = this.tx().getTables(dbName).map(k -> {
                TableMeta m = new TableMeta();
                m.setCatName("hive");
                m.setDbName(k.getElements().get(0));
                m.setTableName(k.getElements().get(1));
                return m;
            }).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, UnknownDBException {
        try (NessieTransaction.Handle h = this.txo();){
            List<Table> list = this.tx().getTables(dbName, tableNames);
            return list;
        }
    }

    @Override
    public List<String> getAllTables(String dbName) throws MetaException {
        try (NessieTransaction.Handle h = this.txo();){
            List<String> list = this.tx().getTables(dbName).map(k -> k.getElements().get(1)).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, UnknownDBException {
        try (NessieTransaction.Handle h = this.txo();){
            List<String> list = this.tx().getTables(dbName).map(k -> k.getElements().get(1)).limit(maxTables).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<String> listPartitionNames(String dbName, String tblName, short maxParts) throws MetaException {
        NessieTransaction.Handle h = this.txo();
        try {
            NessieTransaction.TableAndPartition tbl = this.tx().getTable(dbName, tblName).orElseThrow(() -> new NoSuchObjectException());
            List<String> list = tbl.getPartitions().stream().map(p -> {
                try {
                    return Warehouse.makePartName((List)tbl.getTable().getPartitionKeys(), (List)p.getValues());
                }
                catch (MetaException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            if (h != null) {
                h.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (h != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NoSuchObjectException e) {
                throw new MetaException(String.format("Requested table [%s.%s] does not exist.", dbName, tblName));
            }
        }
    }

    @Override
    public PartitionValuesResponse listPartitionValues(String dbName, String tblName, List<FieldSchema> cols, boolean applyDistinct, String filter, boolean ascending, List<FieldSchema> order, long maxParts) throws MetaException {
        throw new MetaException("Not yet supported.");
    }

    @Override
    public void alterPartition(String dbName, String tblName, List<String> partVals, Partition newPart) throws InvalidObjectException, MetaException {
    }

    @Override
    public void alterPartitions(String dbName, String tblName, List<List<String>> partValsList, List<Partition> newParts) throws InvalidObjectException, MetaException {
    }

    @Override
    public List<Partition> getPartitionsByFilter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException {
        return null;
    }

    @Override
    public boolean getPartitionsByExpr(String dbName, String tblName, byte[] expr, String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
        try (NessieTransaction.Handle h = this.txo();){
            NessieTransaction.TableAndPartition tandp = this.tx().getTable(dbName, tblName).orElseThrow(() -> new NoSuchObjectException());
            List partitionKeys = tandp.getTable().getPartitionKeys();
            Map partByName = tandp.getPartitions().stream().collect(Collectors.toMap(p -> {
                try {
                    return Warehouse.makePartName((List)partitionKeys, (List)p.getValues());
                }
                catch (MetaException e) {
                    throw new RuntimeException(e);
                }
            }, Function.identity()));
            ArrayList<String> partitionNames = new ArrayList<String>(partByName.keySet());
            boolean resultBool = PartitionFilterer.filterPartitionsByExpr(this.conf, tandp.getTable().getPartitionKeys(), expr, partitionNames);
            for (String name : partitionNames) {
                result.add((Partition)partByName.get(name));
            }
            boolean bl = resultBool;
            return bl;
        }
    }

    @Override
    public int getNumPartitionsByFilter(String dbName, String tblName, String filter) throws MetaException, NoSuchObjectException {
        return 1;
    }

    @Override
    public int getNumPartitionsByExpr(String dbName, String tblName, byte[] expr) throws MetaException, NoSuchObjectException {
        return 1;
    }

    @Override
    public List<Partition> getPartitionsByNames(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        try (NessieTransaction.Handle h = this.txo();){
            NessieTransaction.TableAndPartition tandp = this.tx().getTable(dbName, tblName).orElseThrow(() -> new NoSuchObjectException());
            List partitionKeys = tandp.getTable().getPartitionKeys();
            HashSet<String> parts = new HashSet<String>(partNames);
            List<Partition> list = tandp.getPartitions().stream().filter(p -> {
                String name;
                try {
                    name = Warehouse.makePartName((List)partitionKeys, (List)p.getValues());
                }
                catch (MetaException e) {
                    throw new RuntimeException(e);
                }
                return parts.contains(name);
            }).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Partition> listPartitionsPsWithAuth(String dbName, String tblName, List<String> partVals, short maxParts, String userName, List<String> groupNames) throws MetaException, InvalidObjectException, NoSuchObjectException {
        return null;
    }

    @Override
    public String getMetaStoreSchemaVersion() throws MetaException {
        return null;
    }

    @Override
    public List<String> listPartitionNamesByFilter(String dbName, String tblName, String filter, short maxParts) throws MetaException {
        return null;
    }

    private static PartitionExpressionProxy createExpressionProxy(Configuration conf) {
        String className = conf.get("hive.metastore.expression.proxy");
        try {
            Class<PartitionExpressionProxy> clazz = NessieStoreImpl.getClass(className, PartitionExpressionProxy.class);
            return NessieStoreImpl.newInstance(clazz, new Class[0], new Object[0]);
        }
        catch (MetaException e) {
            LOG.error("Error loading PartitionExpressionProxy", (Throwable)e);
            throw new RuntimeException("Error loading PartitionExpressionProxy: " + e.getMessage());
        }
    }

    private static <T> T newInstance(Class<T> theClass, Class<?>[] parameterTypes, Object[] initargs) {
        if (parameterTypes.length != initargs.length) {
            throw new IllegalArgumentException("Number of constructor parameter types doesn't match number of arguments");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> clazz = parameterTypes[i];
            if (initargs[i] == null || clazz.isInstance(initargs[i])) continue;
            throw new IllegalArgumentException("Object : " + initargs[i] + " is not an instance of " + clazz);
        }
        try {
            Constructor<T> meth = theClass.getDeclaredConstructor(parameterTypes);
            meth.setAccessible(true);
            return meth.newInstance(initargs);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + theClass.getName(), e);
        }
    }

    private static <T> Class<? extends T> getClass(String className, Class<T> clazz) throws MetaException {
        try {
            return Class.forName(className, true, NessieStoreImpl.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MetaException(className + " class not found");
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JavaUtils.class.getClassLoader();
        }
        return classLoader;
    }

    @Override
    public int getDatabaseCount() throws MetaException {
        return 0;
    }

    @Override
    public int getTableCount() throws MetaException {
        return 0;
    }

    @Override
    public int getPartitionCount() throws MetaException {
        return 0;
    }

    @Override
    public Map<String, List<String>> getPartitionColsWithStats(String dbName, String tableName) throws MetaException, NoSuchObjectException {
        return null;
    }
}

