/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.projectnessie.client.NessieClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.hms.Item;
import org.projectnessie.hms.TransactionStore;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.Reference;

class NessieTransaction {
    private final String defaultName;
    private final String defaultHash;
    private final TransactionStore store;
    private int transactionCount;
    private boolean rolledback;
    private final Runnable closeListener;
    private final Handle handle;

    public NessieTransaction(String ref, NessieClient client, Runnable closeListener) {
        Reference reference;
        this.closeListener = closeListener;
        this.handle = new Handle();
        try {
            reference = ref == null ? client.getTreeApi().getDefaultBranch() : client.getTreeApi().getReferenceByName(ref);
        }
        catch (NessieNotFoundException e) {
            if (ref == null) {
                throw new RuntimeException("Cannot start transaction, unable to retrieve default branch from server.", e);
            }
            throw new RuntimeException(String.format("Cannot start transaction, Provided reference [%s] does not exist.", ref), e);
        }
        this.store = new TransactionStore(reference, client.getContentsApi(), client.getTreeApi());
        this.defaultHash = reference.getHash();
        this.defaultName = reference.getName();
        ++this.transactionCount;
    }

    public void nestedOpen() {
        Preconditions.checkArgument((this.transactionCount >= 1 ? 1 : 0) != 0);
        ++this.transactionCount;
    }

    public void rollback() {
        Preconditions.checkArgument((this.transactionCount >= 1 ? 1 : 0) != 0);
        --this.transactionCount;
        this.rolledback = true;
        if (this.transactionCount == 0) {
            this.closeListener.run();
        }
    }

    public boolean commit() {
        Preconditions.checkArgument((this.transactionCount >= 1 ? 1 : 0) != 0);
        if (this.rolledback) {
            return false;
        }
        if (this.transactionCount > 1) {
            --this.transactionCount;
            return true;
        }
        try {
            this.store.commit();
            --this.transactionCount;
            this.closeListener.run();
            return true;
        }
        catch (NessieConflictException | NessieNotFoundException e) {
            return false;
        }
    }

    public List<Table> getTables(String dbName, List<String> tableNames) {
        List<TransactionStore.RefKey> keys = tableNames.stream().map(t -> new TransactionStore.RefKey(this.defaultHash, ContentsKey.of(dbName, t))).collect(Collectors.toList());
        try {
            return this.store.getItemsForRef(keys).stream().filter(Optional::isPresent).map(Optional::get).map(Item::getTable).collect(Collectors.toList());
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException("Selected reference disappeared during operation.", ex);
        }
    }

    Stream<ContentsKey> getTables(String database) {
        try {
            return this.store.getEntriesForDefaultRef().map(EntriesResponse.Entry::getName).filter(k -> k.getElements().size() != 1).filter(k -> k.getElements().get(0).equalsIgnoreCase(database));
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void createDatabase(Database db) throws MetaException {
        this.setItem(Item.wrap(db), db.getName());
    }

    public void alterDatabase(Database db) throws MetaException {
        this.setItem(Item.wrap(db), db.getName());
    }

    public Stream<String> getDatabases() {
        try {
            return this.store.getEntriesForDefaultRef().map(EntriesResponse.Entry::getName).filter(k -> k.getElements().size() == 1).map(k -> k.getElements().get(0));
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addPartitions(List<Partition> p) throws MetaException, InvalidObjectException, NoSuchObjectException {
        if (p.isEmpty()) {
            return;
        }
        Optional<TableAndPartition> table = this.getTable(p.get(0).getDbName(), p.get(0).getTableName());
        if (!table.isPresent()) {
            throw new InvalidObjectException();
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.addAll(table.get().getPartitions());
        partitions.addAll(p);
        this.setItem(Item.wrap(table.get().getTable(), partitions), new String[0]);
    }

    public void createTable(Table table) throws MetaException {
        this.setItem(Item.wrap(table, Collections.emptyList()), table.getDbName(), table.getTableName());
    }

    public void alterTable(Table table) throws MetaException, NoSuchObjectException {
        Optional<TableAndPartition> oldItem = this.getTable(table.getDbName(), table.getTableName());
        if (!oldItem.isPresent()) {
            throw new MetaException("Table doesn't exist.");
        }
        this.setItem(Item.wrap(table, oldItem.get().getPartitions()), table.getDbName(), table.getTableName());
    }

    public Handle handle() {
        return this.handle;
    }

    public Table getTableOnly(String dbName, String tableName) throws NoSuchObjectException {
        return this.getTable(dbName, tableName).map(TableAndPartition::getTable).orElseThrow(() -> new NoSuchObjectException());
    }

    public Optional<TableAndPartition> getTable(String dbName, String tableName) throws NoSuchObjectException {
        if (!tableName.contains("@")) {
            return this.getItemForRef(this.defaultHash, dbName, tableName).map(i -> new TableAndPartition(i.getTable(), i.getPartitions()));
        }
        String[] split = tableName.split("@");
        if (split.length != 2) {
            throw new NoSuchObjectException("Invalid reference.");
        }
        String tName = split[0];
        String ref = split[1];
        if (ref.equalsIgnoreCase(this.defaultName) || ref.equalsIgnoreCase(this.defaultHash)) {
            return this.getItemForRef(this.defaultHash, dbName, tableName).map(i -> new TableAndPartition(i.getTable(), i.getPartitions()));
        }
        return this.getItemForRef(ref, dbName, tName).map(i -> {
            Table t = i.getTable();
            t.setTableName(t.getTableName() + "@" + ref);
            List<Partition> parts = i.getPartitions();
            parts.forEach(p -> p.setTableName(p.getTableName() + "@" + ref));
            return new TableAndPartition(t, parts);
        });
    }

    public void save(TableAndPartition tandp) throws MetaException {
        this.setItem(Item.wrap(tandp.table, tandp.partitions), tandp.table.getDbName(), tandp.table.getTableName());
    }

    private void setItem(Item item, String ... keyElements) throws MetaException {
        ContentsKey key = ContentsKey.of(keyElements);
        this.store.setItem(key, item);
    }

    public void deleteTable(String dbName, String tableName) throws MetaException {
        this.deleteItem(dbName, tableName);
    }

    public void deleteDatabase(String db) throws MetaException {
        this.deleteItem(db);
    }

    private void deleteItem(String ... keyElements) throws MetaException {
        ContentsKey key = ContentsKey.of(keyElements);
        this.store.deleteItem(key);
    }

    public List<Partition> getPartitions(String dbName, String tableName) throws NoSuchObjectException {
        Optional<TableAndPartition> item = this.getTable(dbName, tableName);
        return item.map(TableAndPartition::getPartitions).orElse(null);
    }

    public void removePartition(String dbName, String tableName, List<String> partitionValues) throws MetaException, NoSuchObjectException {
        ArrayList<Partition> newPartitions = new ArrayList<Partition>();
        Optional<TableAndPartition> opt = this.getTable(dbName, tableName);
        if (!opt.isPresent()) {
            throw new NoSuchObjectException();
        }
        for (Partition p : opt.get().getPartitions()) {
            if (p.getValues().equals(partitionValues)) continue;
            newPartitions.add(p);
        }
        this.setItem(Item.wrap(opt.get().getTable(), newPartitions), new String[0]);
    }

    Optional<Database> getDatabase(String database) throws NoSuchObjectException {
        return this.getItemForRef(this.defaultHash, database).map(Item::getDatabase);
    }

    private Optional<Item> getItemForRef(String ref, String ... elements) throws NoSuchObjectException {
        return this.store.getItemForRef(ref, ContentsKey.of(elements));
    }

    public Handle start() {
        this.nestedOpen();
        return new Handle();
    }

    public boolean isActive() {
        return this.transactionCount > 0;
    }

    public void execute(Consumer<NessieTransaction> t) {
    }

    public static class TableAndPartition {
        private final Table table;
        private final List<Partition> partitions;

        public TableAndPartition(Item i) {
            this(i.getTable(), i.getPartitions());
        }

        public TableAndPartition(Table table, List<Partition> partitions) {
            this.table = table;
            this.partitions = partitions;
        }

        public Table getTable() {
            return this.table;
        }

        public List<Partition> getPartitions() {
            return this.partitions;
        }
    }

    public class Handle
    implements AutoCloseable {
        @Override
        public void close() {
            boolean success = false;
            try {
                success = NessieTransaction.this.commit();
            }
            finally {
                if (!success) {
                    NessieTransaction.this.rollback();
                }
            }
        }
    }
}

