/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.OptionalInt;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;

public final class StreamingUtil {
    private StreamingUtil() {
    }

    public static Stream<EntriesResponse.Entry> getEntriesStream(@NotNull TreeApi treeApi, @NotNull String ref, @NotNull EntriesParams entriesParams) throws NessieNotFoundException {
        return new ResultStreamPaginator(EntriesResponse::getEntries, (ref1, pageSize, token) -> treeApi.getEntries(ref1, EntriesParams.builder().from(entriesParams).maxRecords(pageSize).pageToken(token).build())).generateStream(ref, OptionalInt.of(entriesParams.getMaxRecords()));
    }

    public static Stream<CommitMeta> getCommitLogStream(@NotNull TreeApi treeApi, @NotNull String ref, @NotNull CommitLogParams commitLogParams) throws NessieNotFoundException {
        return new ResultStreamPaginator(LogResponse::getOperations, (reference, pageSize, token) -> treeApi.getCommitLog(reference, CommitLogParams.builder().from(commitLogParams).maxRecords(pageSize).pageToken(token).build())).generateStream(ref, OptionalInt.of(commitLogParams.getMaxRecords()));
    }
}

