/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.hms;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.hms.BaseHiveOps;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.HiveDatabase;
import org.projectnessie.model.HiveTable;

public abstract class BaseDelegateOps
extends BaseHiveOps {
    @Test
    public void crossNessieDelegateQuery() throws NessieNotFoundException {
        this.shell.execute("create table legacy (a int, b int)");
        this.shell.execute("insert into legacy select 1 as a,1 as b union all select 2,2 union all select 3,3 union all select 4,4 ");
        this.shell.execute("create database mytestdb");
        this.shell.execute("create external table mytestdb.nessie (a int, b int) PARTITIONED BY (c int) TBLPROPERTIES (\"immutable\"=\"true\")");
        this.shell.execute("insert into mytestdb.nessie PARTITION(c)select 1 as a,1 as b,1 as c union all select 2,2,2 union all select 3,3,3 union all select 4,4,4 ");
        List results = this.shell.executeQuery("select * from legacy l join mytestdb.nessie n on l.a = n.a");
        Assertions.assertEquals((int)4, (int)results.size());
        Contents db = client.getContentsApi().getContents(ContentsKey.of("mytestdb"), null);
        Assertions.assertNotNull((Object)db);
        Assertions.assertTrue((boolean)HiveDatabase.class.isAssignableFrom(db.getClass()));
        Contents tbl = client.getContentsApi().getContents(ContentsKey.of("mytestdb", "nessie"), null);
        Assertions.assertNotNull((Object)tbl);
        Assertions.assertTrue((boolean)HiveTable.class.isAssignableFrom(tbl.getClass()));
        Assertions.assertEquals((int)2, (int)client.getTreeApi().getEntries("main", EntriesParams.empty()).getEntries().size());
    }
}

