/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableContentsKey;
import org.projectnessie.model.Namespace;

@JsonSerialize(as=ImmutableContentsKey.class)
@JsonDeserialize(as=ImmutableContentsKey.class)
@Value.Immutable(prehash=true)
public abstract class ContentsKey {
    private static final char ZERO_BYTE = '\u0000';
    private static final String ZERO_BYTE_STRING = Character.toString('\u0000');

    @NotNull
    @Size(min=1)
    public abstract @NotNull @Size(min=1) List<String> getElements();

    @JsonIgnore
    @Value.Derived
    public Namespace getNamespace() {
        return Namespace.of(this.getElements());
    }

    public static ContentsKey of(String ... elements) {
        return ImmutableContentsKey.builder().elements(Arrays.asList(elements)).build();
    }

    @JsonCreator
    public static ContentsKey of(@JsonProperty(value="elements") List<String> elements) {
        return ImmutableContentsKey.builder().elements(elements).build();
    }

    @Value.Check
    protected void validate() {
        for (String e : this.getElements()) {
            if (!e.contains(ZERO_BYTE_STRING)) continue;
            throw new IllegalArgumentException("An object key cannot contain a zero byte.");
        }
    }

    public static ContentsKey fromPathString(String encoded) {
        List<String> elements = Arrays.stream(encoded.split("\\.")).map(x -> x.replace('\u0000', '.')).collect(Collectors.toList());
        return ContentsKey.of(elements);
    }

    public String toPathString() {
        return this.getElements().stream().map(x -> x.replace('.', '\u0000')).collect(Collectors.joining("."));
    }

    public String toString() {
        return String.join((CharSequence)".", this.getElements());
    }
}

