package org.projectnessie;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.FileMetadataHandler;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.projectnessie.hms.BaseRawStore3;
import org.projectnessie.hms.Empties;

public class Hive3NessieRawStore extends BaseRawStore3 {
  public Hive3NessieRawStore() {
    super(false);
  }

  public Hive3NessieRawStore(boolean delegate) {
    super(delegate);
  }

  @Override
  public Table getTable(String catalogName, String dbName, String tableName) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTable(catalogName, dbName, tableName);
    } else {
      return nessie.getTable(dbName, tableName);
    }
  }

  @Override
  public Type getType(String typeName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getType(typeName);
  }

  @Override
  public Function getFunction(String catalogName, String dbName, String funcName) throws
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getFunction(catalogName, dbName, funcName);
    } else {
      return null;
    }
  }

  @Override
  public void createFunction(Function func) throws InvalidObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createFunction(func);
  }

  @Override
  public void alterPartitions(String catalogName, String db_name, String tbl_name,
      List<List<String>> part_vals_list, List<Partition> new_parts) throws InvalidObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      delegate.alterPartitions(catalogName, db_name, tbl_name, part_vals_list, new_parts);
    } else {
      nessie.alterPartitions(db_name, tbl_name, part_vals_list, new_parts);
    }
  }

  @Override
  public List<Partition> getPartitions(String catalogName, String dbName, String tableName, int max)
      throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitions(catalogName, dbName, tableName, max);
    } else {
      return nessie.getPartitions(dbName, tableName, max);
    }
  }

  @Override
  public boolean getPartitionsByExpr(String catalogName, String dbName, String tblName, byte[] expr,
      String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsByExpr(catalogName, dbName, tblName, expr, defaultPartitionName, maxParts, result);
    } else {
      return nessie.getPartitionsByExpr(dbName, tblName, expr, defaultPartitionName, maxParts, result);
    }
  }

  @Override
  public List<String> getAllTables(String catalogName, String dbName) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getAllTables(catalogName, dbName);
    } else {
      return nessie.getAllTables(dbName);
    }
  }

  @Override
  public boolean dropTable(String catalogName, String dbName, String tableName) throws
      MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.dropTable(catalogName, dbName, tableName);
    } else {
      return nessie.dropTable(dbName, tableName);
    }
  }

  @Override
  public boolean addPartitions(String catalogName, String dbName, String tblName,
      List<Partition> parts) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.addPartitions(catalogName, dbName, tblName, parts);
    } else {
      return nessie.addPartitions(dbName, tblName, parts);
    }
  }

  @Override
  public boolean addPartitions(String catalogName, String dbName, String tblName,
      PartitionSpecProxy partitionSpec, boolean ifNotExists) throws InvalidObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.addPartitions(catalogName, dbName, tblName, partitionSpec, ifNotExists);
    } else {
      return nessie.addPartitions(dbName, tblName, partitionSpec, ifNotExists);
    }
  }

  @Override
  public boolean dropDatabase(String catalogName, String dbname) throws NoSuchObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      return delegate.dropDatabase(catalogName, dbname);
    } else {
      return nessie.dropDatabase(dbname);
    }
  }

  @Override
  public boolean alterDatabase(String catalogName, String dbname, Database db) throws
      NoSuchObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      return delegate.alterDatabase(catalogName, dbname, db);
    } else {
      return nessie.alterDatabase(dbname, db);
    }
  }

  @Override
  public List<Partition> getPartitionsWithAuth(String catalogName, String dbName, String tblName,
      short maxParts, String userName, List<String> groupNames) throws MetaException,
      NoSuchObjectException, InvalidObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsWithAuth(catalogName, dbName, tblName, maxParts, userName, groupNames);
    } else {
      return nessie.getPartitionsWithAuth(dbName, tblName, maxParts, userName, groupNames);
    }
  }

  @Override
  public void createTable(Table tbl) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(tbl))) {
      delegate.createTable(tbl);
    } else {
      nessie.createTable(tbl);
    }
  }

  @Override
  public void createDatabase(Database db) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db))) {
      delegate.createDatabase(db);
    } else {
      nessie.createDatabase(db);
    }
  }

  @Override
  public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(part))) {
      return delegate.addPartition(part);
    } else {
      return nessie.addPartition(part);
    }
  }

  @Override
  public int getDatabaseCount() throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getDatabaseCount(), nessie.getDatabaseCount());
    } else {
      return nessie.getDatabaseCount();
    }
  }

  @Override
  public int getTableCount() throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getTableCount(), nessie.getTableCount());
    } else {
      return nessie.getTableCount();
    }
  }

  @Override
  public int getPartitionCount() throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getPartitionCount(), nessie.getPartitionCount());
    } else {
      return nessie.getPartitionCount();
    }
  }

  @Override
  public boolean dropPartition(String catalogName, String dbName, String tableName,
      List<String> part_vals) throws MetaException, NoSuchObjectException, InvalidObjectException,
      InvalidInputException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.dropPartition(catalogName, dbName, tableName, part_vals);
    } else {
      return nessie.dropPartition(dbName, tableName, part_vals);
    }
  }

  @Override
  public List<TableMeta> getTableMeta(String catalogName, String dbNames, String tableNames,
      List<String> tableTypes) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbNames))) {
      return delegate.getTableMeta(catalogName, dbNames, tableNames, tableTypes);
    } else {
      return nessie.getTableMeta(dbNames, tableNames, tableTypes);
    }
  }

  @Override
  public List<String> getAllDatabases(String catalogName) throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getAllDatabases(catalogName), nessie.getAllDatabases());
    } else {
      return nessie.getAllDatabases();
    }
  }

  @Override
  public List<String> listTableNamesByFilter(String catalogName, String dbName, String filter,
      short max_tables) throws MetaException, UnknownDBException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.listTableNamesByFilter(catalogName, dbName, filter, max_tables);
    } else {
      return nessie.listTableNamesByFilter(dbName, filter, max_tables);
    }
  }

  @Override
  public void alterTable(String catalogName, String dbname, String name, Table newTable) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      delegate.alterTable(catalogName, dbname, name, newTable);
    } else {
      nessie.alterTable(dbname, name, newTable);
    }
  }

  @Override
  public List<Table> getTableObjectsByName(String catalogName, String dbname,
      List<String> tableNames) throws MetaException, UnknownDBException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbname))) {
      return delegate.getTableObjectsByName(catalogName, dbname, tableNames);
    } else {
      return nessie.getTableObjectsByName(dbname, tableNames);
    }
  }

  @Override
  public List<Partition> getPartitionsByNames(String catalogName, String dbName, String tblName,
      List<String> partNames) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsByNames(catalogName, dbName, tblName, partNames);
    } else {
      return nessie.getPartitionsByNames(dbName, tblName, partNames);
    }
  }

  @Override
  public boolean doesPartitionExist(String catalogName, String dbName, String tableName,
      List<String> part_vals) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.doesPartitionExist(catalogName, dbName, tableName, part_vals);
    } else {
      return nessie.doesPartitionExist(dbName, tableName, part_vals);
    }
  }

  @Override
  public List<Partition> getPartitionsByFilter(String catalogName, String dbName, String tblName,
      String filter, short maxParts) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionsByFilter(catalogName, dbName, tblName, filter, maxParts);
    } else {
      return nessie.getPartitionsByFilter(dbName, tblName, filter, maxParts);
    }
  }

  @Override
  public List<String> getTables(String catalogName, String dbName, String pattern) throws
      MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTables(catalogName, dbName, pattern);
    } else {
      return nessie.getTables(dbName, pattern);
    }
  }

  @Override
  public List<String> getTables(String catalogName, String dbName, String pattern,
      TableType tableType) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTables(catalogName, dbName, pattern, tableType);
    } else {
      return nessie.getTables(dbName, pattern, tableType);
    }
  }

  @Override
  public Partition getPartitionWithAuth(String catalogName, String dbName, String tblName,
      List<String> partVals, String user_name, List<String> group_names) throws MetaException,
      NoSuchObjectException, InvalidObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionWithAuth(catalogName, dbName, tblName, partVals, user_name, group_names);
    } else {
      return nessie.getPartitionWithAuth(dbName, tblName, partVals, user_name, group_names);
    }
  }

  @Override
  public void alterFunction(String catalogName, String dbName, String funcName,
      Function newFunction) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      delegate.alterFunction(catalogName, dbName, funcName, newFunction);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public AggrStats get_aggr_stats_for(String catalogName, String dbName, String tblName,
      List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      return delegate.get_aggr_stats_for(catalogName, dbName, tblName, partNames, colNames);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata,
      FileMetadataExprType type) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.putFileMetadata(fileIds, metadata, type);
  }

  @Override
  public List<SQLForeignKey> getForeignKeys(String catalogName, String parent_db_name,
      String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(parent_db_name))) {
      return delegate.getForeignKeys(catalogName, parent_db_name, parent_tbl_name, foreign_db_name, foreign_tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<SQLPrimaryKey> getPrimaryKeys(String catalogName, String db_name, String tbl_name)
      throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.getPrimaryKeys(catalogName, db_name, tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public void dropConstraint(String catalogName, String dbName, String tableName,
      String constraintName) throws NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      delegate.dropConstraint(catalogName, dbName, tableName, constraintName);
    } else {
      return;
    }
  }

  @Override
  public void dropConstraint(String catalogName, String dbName, String tableName,
      String constraintName, boolean missingOk) throws NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.dropConstraint(catalogName, dbName, tableName, constraintName, missingOk);
    } else {
      return;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalDBGrants(String principalName,
      PrincipalType principalType, String catName, String dbName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalDBGrants(principalName, principalType, catName, dbName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String principalName,
      PrincipalType principalType, String catName, String dbName, String tableName,
      List<String> partValues, String partName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listPrincipalPartitionGrants(principalName, principalType, catName, dbName, tableName, partValues, partName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listAllTableGrants(String principalName,
      PrincipalType principalType, String catName, String dbName, String tableName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listAllTableGrants(principalName, principalType, catName, dbName, tableName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<String> addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(pks.stream().flatMap(BaseRawStore3::route))) {
      return delegate.addPrimaryKeys(pks);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public boolean dropType(String typeName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.dropType(typeName);
  }

  @Override
  public void updateCreationMetadata(String catalogName, String dbname, String tablename,
      CreationMetadata cm) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.updateCreationMetadata(catalogName, dbname, tablename, cm);
  }

  @Override
  public List<String> listRoleNames() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listRoleNames();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public boolean addRole(String rowName, String ownerName) throws InvalidObjectException,
      MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.addRole(rowName, ownerName);
    } else {
      return true;
    }
  }

  @Override
  public Role getRole(String roleName) throws NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getRole(roleName);
  }

  @Override
  public String[] getMasterKeys() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getMasterKeys();
    } else {
      return new String[0];
    }
  }

  @Override
  public void getFileMetadataByExpr(List<Long> fileIds, FileMetadataExprType type, byte[] expr,
      ByteBuffer[] metadatas, ByteBuffer[] exprResults, boolean[] eliminated) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.getFileMetadataByExpr(fileIds, type, expr, metadatas, exprResults, eliminated);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalDBGrantsAll(principalName, principalType);
  }

  @Override
  public List<MetaStoreUtils.ColStatsObjWithSourceInfo> getPartitionColStatsForDatabase(
      String catalogName, String dbName) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionColStatsForDatabase(catalogName, dbName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<String> addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(fks.stream().flatMap(BaseRawStore3::route))) {
      return delegate.addForeignKeys(fks);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public void createCatalog(Catalog cat) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.createCatalog(cat);
    } else {
      return;
    }
  }

  @Override
  public void alterCatalog(String catName, Catalog cat) throws MetaException,
      InvalidOperationException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.alterCatalog(catName, cat);
  }

  @Override
  public Catalog getCatalog(String catalogName) throws NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getCatalog(catalogName);
    } else {
      return Empties.defaultCatalog();
    }
  }

  @Override
  public void dropCatalog(String catalogName) throws NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropCatalog(catalogName);
  }

  @Override
  public PrincipalPrivilegeSet getDBPrivilegeSet(String catalogName, String dbName, String userName,
      List<String> groupNames) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getDBPrivilegeSet(catalogName, dbName, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public List<Function> getAllFunctions(String catalogName) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getAllFunctions(catalogName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listDBGrantsAll(String catalogName, String dbName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listDBGrantsAll(catalogName, dbName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public PrincipalPrivilegeSet getTablePrivilegeSet(String catalogName, String dbName,
      String tableName, String userName, List<String> groupNames) throws InvalidObjectException,
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTablePrivilegeSet(catalogName, dbName, tableName, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public List<String> listPartitionNamesPs(String catalogName, String db_name, String tbl_name,
      List<String> part_vals, short max_parts) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionNamesPs(catalogName, db_name, tbl_name, part_vals, max_parts);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public PrincipalPrivilegeSet getColumnPrivilegeSet(String catalogName, String dbName,
      String tableName, String partitionName, String columnName, String userName,
      List<String> groupNames) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getColumnPrivilegeSet(catalogName, dbName, tableName, partitionName, columnName, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public List<String> getFunctions(String catalogName, String dbName, String pattern) throws
      MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getFunctions(catalogName, dbName, pattern);
    } else {
      return null;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listTableColumnGrantsAll(String catalogName, String dbName,
      String tableName, String columnName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listTableColumnGrantsAll(catalogName, dbName, tableName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<ColumnStatistics> getPartitionColumnStatistics(String catalogName, String dbName,
      String tblName, List<String> partNames, List<String> colNames) throws MetaException,
      NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionColumnStatistics(catalogName, dbName, tblName, partNames, colNames);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public void dropFunction(String catalogName, String dbName, String funcName) throws MetaException,
      NoSuchObjectException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      delegate.dropFunction(catalogName, dbName, funcName);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String catalogName, String dbName,
      String tableName, String partitionName, String columnName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listPartitionColumnGrantsAll(catalogName, dbName, tableName, partitionName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public FileMetadataHandler getFileMetadataHandler(FileMetadataExprType type) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getFileMetadataHandler(type);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String principalName,
      PrincipalType principalType, String catName, String dbName, String tableName,
      List<String> partValues, String partName, String columnName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalPartitionColumnGrants(principalName, principalType, catName, dbName, tableName, partValues, partName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String principalName,
      PrincipalType principalType, String catName, String dbName, String tableName,
      String columnName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalTableColumnGrants(principalName, principalType, catName, dbName, tableName, columnName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public void addSerde(SerDeInfo serde) throws AlreadyExistsException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.addSerde(serde);
  }

  @Override
  public SerDeInfo getSerDeInfo(String serDeName) throws NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getSerDeInfo(serDeName);
  }

  @Override
  public void dropWMTrigger(String resourcePlanName, String triggerName) throws
      NoSuchObjectException, InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropWMTrigger(resourcePlanName, triggerName);
  }

  @Override
  public int deleteRuntimeStats(int maxRetainSecs) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.deleteRuntimeStats(maxRetainSecs);
    } else {
      return 0;
    }
  }

  @Override
  public void dropResourcePlan(String name) throws NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropResourcePlan(name);
  }

  @Override
  public void createWMTriggerToPoolMapping(String resourcePlanName, String triggerName,
      String poolPath) throws AlreadyExistsException, NoSuchObjectException,
      InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createWMTriggerToPoolMapping(resourcePlanName, triggerName, poolPath);
  }

  @Override
  public List<Partition> listPartitionsPsWithAuth(String catalogName, String db_name,
      String tbl_name, List<String> part_vals, short max_parts, String userName,
      List<String> groupNames) throws MetaException, InvalidObjectException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionsPsWithAuth(catalogName, db_name, tbl_name, part_vals, max_parts, userName, groupNames);
    } else {
      return nessie.listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, userName, groupNames);
    }
  }

  @Override
  public void alterPartition(String catalogName, String db_name, String tbl_name,
      List<String> part_vals, Partition new_part) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      delegate.alterPartition(catalogName, db_name, tbl_name, part_vals, new_part);
    } else {
      nessie.alterPartition(db_name, tbl_name, part_vals, new_part);
    }
  }

  @Override
  public NotificationEventsCountResponse getNotificationEventsCount(
      NotificationEventsCountRequest rqst) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getNotificationEventsCount(rqst);
    } else {
      return Empties.eventCount();
    }
  }

  @Override
  public List<SQLUniqueConstraint> getUniqueConstraints(String catalogName, String db_name,
      String tbl_name) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.getUniqueConstraints(catalogName, db_name, tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<SQLNotNullConstraint> getNotNullConstraints(String catalogName, String db_name,
      String tbl_name) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.getNotNullConstraints(catalogName, db_name, tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<SQLDefaultConstraint> getDefaultConstraints(String catalogName, String db_name,
      String tbl_name) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.getDefaultConstraints(catalogName, db_name, tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<SQLCheckConstraint> getCheckConstraints(String catalogName, String db_name,
      String tbl_name) throws MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(db_name))) {
      return delegate.getCheckConstraints(catalogName, db_name, tbl_name);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<String> addUniqueConstraints(List<SQLUniqueConstraint> uks) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(uks.stream().flatMap(BaseRawStore3::route))) {
      return delegate.addUniqueConstraints(uks);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<String> addNotNullConstraints(List<SQLNotNullConstraint> nns) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(nns.stream().flatMap(BaseRawStore3::route))) {
      return delegate.addNotNullConstraints(nns);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<String> addDefaultConstraints(List<SQLDefaultConstraint> dv) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(dv.stream().flatMap(BaseRawStore3::route))) {
      return delegate.addDefaultConstraints(dv);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<String> addCheckConstraints(List<SQLCheckConstraint> cc) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(cc.stream().flatMap(BaseRawStore3::route))) {
      return delegate.addCheckConstraints(cc);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public void createResourcePlan(WMResourcePlan resourcePlan, String copyFrom, int defaultPoolSize)
      throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createResourcePlan(resourcePlan, copyFrom, defaultPoolSize);
  }

  @Override
  public WMFullResourcePlan getResourcePlan(String name) throws NoSuchObjectException,
      MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getResourcePlan(name);
  }

  @Override
  public List<WMResourcePlan> getAllResourcePlans() throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getAllResourcePlans();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public WMFullResourcePlan alterResourcePlan(String name, WMNullableResourcePlan resourcePlan,
      boolean canActivateDisabled, boolean canDeactivate, boolean isReplace) throws
      AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.alterResourcePlan(name, resourcePlan, canActivateDisabled, canDeactivate, isReplace);
  }

  @Override
  public WMFullResourcePlan getActiveResourcePlan() throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getActiveResourcePlan();
  }

  @Override
  public WMValidateResourcePlanResponse validateResourcePlan(String name) throws
      NoSuchObjectException, InvalidObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.validateResourcePlan(name);
  }

  @Override
  public void createWMTrigger(WMTrigger trigger) throws AlreadyExistsException,
      NoSuchObjectException, InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createWMTrigger(trigger);
  }

  @Override
  public void alterWMTrigger(WMTrigger trigger) throws NoSuchObjectException,
      InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.alterWMTrigger(trigger);
  }

  @Override
  public List<WMTrigger> getTriggersForResourcePlan(String resourcePlanName) throws
      NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getTriggersForResourcePlan(resourcePlanName);
  }

  @Override
  public void createPool(WMPool pool) throws AlreadyExistsException, NoSuchObjectException,
      InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createPool(pool);
  }

  @Override
  public void alterPool(WMNullablePool pool, String poolPath) throws AlreadyExistsException,
      NoSuchObjectException, InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.alterPool(pool, poolPath);
  }

  @Override
  public void dropWMPool(String resourcePlanName, String poolPath) throws NoSuchObjectException,
      InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropWMPool(resourcePlanName, poolPath);
  }

  @Override
  public void createOrUpdateWMMapping(WMMapping mapping, boolean update) throws
      AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createOrUpdateWMMapping(mapping, update);
  }

  @Override
  public void dropWMMapping(WMMapping mapping) throws NoSuchObjectException,
      InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropWMMapping(mapping);
  }

  @Override
  public void dropWMTriggerToPoolMapping(String resourcePlanName, String triggerName,
      String poolPath) throws NoSuchObjectException, InvalidOperationException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropWMTriggerToPoolMapping(resourcePlanName, triggerName, poolPath);
  }

  @Override
  public void createISchema(ISchema schema) throws AlreadyExistsException, MetaException,
      NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.createISchema(schema);
  }

  @Override
  public void alterISchema(ISchemaName schemaName, ISchema newSchema) throws NoSuchObjectException,
      MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.alterISchema(schemaName, newSchema);
  }

  @Override
  public ISchema getISchema(ISchemaName schemaName) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getISchema(schemaName);
  }

  @Override
  public void dropISchema(ISchemaName schemaName) throws NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropISchema(schemaName);
  }

  @Override
  public void addSchemaVersion(SchemaVersion schemaVersion) throws AlreadyExistsException,
      InvalidObjectException, NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.addSchemaVersion(schemaVersion);
  }

  @Override
  public void alterSchemaVersion(SchemaVersionDescriptor version, SchemaVersion newVersion) throws
      NoSuchObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.alterSchemaVersion(version, newVersion);
  }

  @Override
  public SchemaVersion getSchemaVersion(SchemaVersionDescriptor version) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getSchemaVersion(version);
  }

  @Override
  public SchemaVersion getLatestSchemaVersion(ISchemaName schemaName) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getLatestSchemaVersion(schemaName);
  }

  @Override
  public List<SchemaVersion> getAllSchemaVersion(ISchemaName schemaName) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getAllSchemaVersion(schemaName);
  }

  @Override
  public List<SchemaVersion> getSchemaVersionsByColumns(String colName, String colNamespace,
      String type) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getSchemaVersionsByColumns(colName, colNamespace, type);
  }

  @Override
  public void dropSchemaVersion(SchemaVersionDescriptor version) throws NoSuchObjectException,
      MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.dropSchemaVersion(version);
  }

  @Override
  public void addRuntimeStat(RuntimeStat stat) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    delegate.addRuntimeStat(stat);
  }

  @Override
  public List<RuntimeStat> getRuntimeStats(int maxEntries, int maxCreateTime) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getRuntimeStats(maxEntries, maxCreateTime);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<MetaStoreUtils.FullTableName> getTableNamesWithStats() throws MetaException,
      NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getTableNamesWithStats();
  }

  @Override
  public List<MetaStoreUtils.FullTableName> getAllTableNamesForStats() throws MetaException,
      NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getAllTableNamesForStats();
  }

  @Override
  public List<RolePrincipalGrant> listRoleMembers(String roleName) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listRoleMembers(roleName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public long cleanupEvents() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.cleanupEvents();
    } else {
      return 0L;
    }
  }

  @Override
  public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException,
      MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.updateMasterKey(seqNo, key);
    } else {
      return;
    }
  }

  @Override
  public boolean revokeRole(Role role, String userName, PrincipalType principalType,
      boolean grantOption) throws MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.revokeRole(role, userName, principalType, grantOption);
  }

  @Override
  public boolean createType(Type type) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.createType(type);
  }

  @Override
  public boolean removeMasterKey(Integer keySeq) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.removeMasterKey(keySeq);
  }

  @Override
  public void addNotificationEvent(NotificationEvent event) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.addNotificationEvent(event);
    } else {
      return;
    }
  }

  @Override
  public ByteBuffer[] getFileMetadata(List<Long> fileIds) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getFileMetadata(fileIds);
  }

  @Override
  public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj, List<String> partVals)
      throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(statsObj))) {
      return delegate.updatePartitionColumnStatistics(statsObj, partVals);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listPrincipalTableGrantsAll(principalName, principalType);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<RolePrincipalGrant> listRolesWithGrants(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listRolesWithGrants(principalName, principalType);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException,
      MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.grantPrivileges(privileges);
    } else {
      return true;
    }
  }

  @Override
  public boolean removeToken(String tokenIdentifier) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.removeToken(tokenIdentifier);
  }

  @Override
  public String getToken(String tokenIdentifier) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.getToken(tokenIdentifier);
  }

  @Override
  public CurrentNotificationEventId getCurrentNotificationEventId() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getCurrentNotificationEventId();
    } else {
      return Empties.eventId();
    }
  }

  @Override
  public List<HiveObjectPrivilege> listTableGrantsAll(String catalogName, String dbName,
      String tableName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listTableGrantsAll(catalogName, dbName, tableName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public ColumnStatistics getTableColumnStatistics(String catalogName, String dbName,
      String tableName, List<String> colName) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getTableColumnStatistics(catalogName, dbName, tableName, colName);
    } else {
      return Empties.colStats();
    }
  }

  @Override
  public boolean grantRole(Role role, String userName, PrincipalType principalType, String grantor,
      PrincipalType grantorType, boolean grantOption) throws MetaException, NoSuchObjectException,
      InvalidObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.grantRole(role, userName, principalType, grantor, grantorType, grantOption);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalPartitionGrantsAll(principalName, principalType);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalTableColumnGrantsAll(principalName, principalType);
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalPartitionColumnGrantsAll(principalName, principalType);
  }

  @Override
  public void verifySchema() throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.verifySchema();
    } else {
      return;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String principalName,
      PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listPrincipalGlobalGrants(principalName, principalType);
  }

  @Override
  public List<Role> listRoles(String principalName, PrincipalType principalType) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.listRoles(principalName, principalType);
  }

  @Override
  public int addMasterKey(String key) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.addMasterKey(key);
  }

  @Override
  public boolean removeRole(String roleName) throws MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.removeRole(roleName);
  }

  @Override
  public void cleanNotificationEvents(int olderThan) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.cleanNotificationEvents(olderThan);
    } else {
      return;
    }
  }

  @Override
  public void flushCache() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.flushCache();
    } else {
      return;
    }
  }

  @Override
  public boolean updateTableColumnStatistics(ColumnStatistics colStats) throws
      NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.updateTableColumnStatistics(colStats);
    } else {
      return true;
    }
  }

  @Override
  public boolean isFileMetadataSupported() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.isFileMetadataSupported();
    } else {
      return true;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listGlobalGrantsAll() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.listGlobalGrantsAll();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getNextNotification(rqst);
    } else {
      return Empties.event();
    }
  }

  @Override
  public PrincipalPrivilegeSet getUserPrivilegeSet(String userName, List<String> groupNames) throws
      InvalidObjectException, MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getUserPrivilegeSet(userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws
      InvalidObjectException, MetaException, NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.revokePrivileges(privileges, grantOption);
    } else {
      return true;
    }
  }

  @Override
  public boolean addToken(String tokenIdentifier, String delegationToken) {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method will throw an exception.
    checkHasDelegate();
    return delegate.addToken(tokenIdentifier, delegationToken);
  }

  @Override
  public void setMetaStoreSchemaVersion(String version, String comment) throws MetaException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      delegate.setMetaStoreSchemaVersion(version, comment);
    } else {
      return;
    }
  }

  @Override
  public List<String> getAllTokenIdentifiers() {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.getAllTokenIdentifiers();
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public List<String> createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys,
      List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints,
      List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints,
      List<SQLCheckConstraint> checkConstraints) throws InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(tbl))) {
      return delegate.createTableWithConstraints(tbl, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public boolean refreshPrivileges(HiveObjectRef objToRefresh, String authorizer,
      PrivilegeBag grantPrivileges) throws InvalidObjectException, MetaException,
      NoSuchObjectException {
    // This method uses a delegate if it exists.
    // If no delegate exists, this method is a noop.
    if (hasDelegate) {
      return delegate.refreshPrivileges(objToRefresh, authorizer, grantPrivileges);
    } else {
      return true;
    }
  }

  @Override
  public boolean deletePartitionColumnStatistics(String catalogName, String dbName,
      String tableName, String partName, List<String> partVals, String colName) throws
      NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.deletePartitionColumnStatistics(catalogName, dbName, tableName, partName, partVals, colName);
    } else {
      return true;
    }
  }

  @Override
  public boolean isPartitionMarkedForEvent(String catalogName, String dbName, String tblName,
      Map<String, String> partName, PartitionEventType evtType) throws MetaException,
      UnknownTableException, InvalidPartitionException, UnknownPartitionException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.isPartitionMarkedForEvent(catalogName, dbName, tblName, partName, evtType);
    } else {
      return true;
    }
  }

  @Override
  public boolean deleteTableColumnStatistics(String catalogName, String dbName, String tableName,
      String colName) throws NoSuchObjectException, MetaException, InvalidObjectException,
      InvalidInputException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.deleteTableColumnStatistics(catalogName, dbName, tableName, colName);
    } else {
      return true;
    }
  }

  @Override
  public List<HiveObjectPrivilege> listPartitionGrantsAll(String catalogName, String dbName,
      String tableName, String partitionName) {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.listPartitionGrantsAll(catalogName, dbName, tableName, partitionName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public PrincipalPrivilegeSet getPartitionPrivilegeSet(String catalogName, String dbName,
      String tableName, String partition, String userName, List<String> groupNames) throws
      InvalidObjectException, MetaException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionPrivilegeSet(catalogName, dbName, tableName, partition, userName, groupNames);
    } else {
      return Empties.privSet();
    }
  }

  @Override
  public Table markPartitionForEvent(String catalogName, String dbName, String tblName,
      Map<String, String> partVals, PartitionEventType evtType) throws MetaException,
      UnknownTableException, InvalidPartitionException, UnknownPartitionException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this will throw an exception.
    if (routeToDelegate(route(dbName))) {
      return delegate.markPartitionForEvent(catalogName, dbName, tblName, partVals, evtType);
    } else {
      throw new IllegalArgumentException("Loud Failure");
    }
  }

  @Override
  public List<String> getMaterializedViewsForRewriting(String catalogName, String dbName) throws
      MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    // If the routing targets nessie, this is a noop.
    if (routeToDelegate(route(dbName))) {
      return delegate.getMaterializedViewsForRewriting(catalogName, dbName);
    } else {
      return Collections.emptyList();
    }
  }

  @Override
  public Database getDatabase(String catalogName, String name) throws NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(name))) {
      return delegate.getDatabase(catalogName, name);
    } else {
      return nessie.getDatabase(name);
    }
  }

  @Override
  public List<String> getDatabases(String catalogName, String pattern) throws MetaException {
    // This method uses a delegate if it exists.
    // Union of implementation results is generated.
    if (hasDelegate) {
      return union(delegate.getDatabases(catalogName, pattern), nessie.getDatabases(pattern));
    } else {
      return nessie.getDatabases(pattern);
    }
  }

  @Override
  public void dropPartitions(String catalogName, String dbName, String tblName,
      List<String> partNames) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      delegate.dropPartitions(catalogName, dbName, tblName, partNames);
    } else {
      nessie.dropPartitions(dbName, tblName, partNames);
    }
  }

  @Override
  public Partition getPartition(String catalogName, String dbName, String tableName,
      List<String> part_vals) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartition(catalogName, dbName, tableName, part_vals);
    } else {
      return nessie.getPartition(dbName, tableName, part_vals);
    }
  }

  @Override
  public List<String> listPartitionNames(String catalogName, String db_name, String tbl_name,
      short max_parts) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionNames(catalogName, db_name, tbl_name, max_parts);
    } else {
      return nessie.listPartitionNames(db_name, tbl_name, max_parts);
    }
  }

  @Override
  public int getNumPartitionsByFilter(String catalogName, String dbName, String tblName,
      String filter) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getNumPartitionsByFilter(catalogName, dbName, tblName, filter);
    } else {
      return nessie.getNumPartitionsByFilter(dbName, tblName, filter);
    }
  }

  @Override
  public PartitionValuesResponse listPartitionValues(String catalogName, String db_name,
      String tbl_name, List<FieldSchema> cols, boolean applyDistinct, String filter,
      boolean ascending, List<FieldSchema> order, long maxParts) throws MetaException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(db_name))) {
      return delegate.listPartitionValues(catalogName, db_name, tbl_name, cols, applyDistinct, filter, ascending, order, maxParts);
    } else {
      return nessie.listPartitionValues(db_name, tbl_name, cols, applyDistinct, filter, ascending, order, maxParts);
    }
  }

  @Override
  public int getNumPartitionsByExpr(String catalogName, String dbName, String tblName, byte[] expr)
      throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getNumPartitionsByExpr(catalogName, dbName, tblName, expr);
    } else {
      return nessie.getNumPartitionsByExpr(dbName, tblName, expr);
    }
  }

  @Override
  public Map<String, List<String>> getPartitionColsWithStats(String catalogName, String dbName,
      String tableName) throws MetaException, NoSuchObjectException {
    // This method is routed based on the database name provided.
    if (routeToDelegate(route(dbName))) {
      return delegate.getPartitionColsWithStats(catalogName, dbName, tableName);
    } else {
      return nessie.getPartitionColsWithStats(dbName, tableName);
    }
  }
}
