/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;

@Consumes(value={"application/json"})
@Path(value="contents")
public interface ContentsApi {
    @GET
    @Produces(value={"application/json"})
    @Path(value="{key}")
    @Operation(summary="Get object content associated with key")
    @APIResponses(value={@APIResponse(responseCode="200", description="Information for table", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="iceberg")}, schema=@Schema(implementation=Contents.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or read object content for a key"), @APIResponse(responseCode="404", description="Table not found on ref")})
    public Contents getContents(@Valid @Parameter(description="object name to search for", examples={@ExampleObject(ref="ContentsKey")}) @PathParam(value="key") ContentsKey var1, @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Reference to use. Defaults to default branch if not provided.", examples={@ExampleObject(ref="ref")}) @QueryParam(value="ref") @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var2, @Nullable @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="hash")}) @QueryParam(value="hashOnRef") @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var3) throws NessieNotFoundException;

    @POST
    @Consumes(value={"application/json"})
    @Operation(summary="Get multiple objects' content")
    @APIResponses(value={@APIResponse(responseCode="200", description="Retrieved successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=MultiGetContentsResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or read object content for a key"), @APIResponse(responseCode="404", description="Provided ref doesn't exists")})
    public MultiGetContentsResponse getMultipleContents(@Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Reference to use. Defaults to default branch if not provided.", examples={@ExampleObject(ref="ref")}) @QueryParam(value="ref") @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @Nullable @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="hash")}) @QueryParam(value="hashOnRef") @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2, @Valid @NotNull @RequestBody(description="Keys to retrieve.") MultiGetContentsRequest var3) throws NessieNotFoundException;
}

