/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.Base;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Hash;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Reference", oneOf={Branch.class, Tag.class, Hash.class}, discriminatorMapping={@DiscriminatorMapping(value="TAG", schema=Tag.class), @DiscriminatorMapping(value="BRANCH", schema=Branch.class), @DiscriminatorMapping(value="HASH", schema=Hash.class)}, discriminatorProperty="type", properties={@SchemaProperty(name="name", pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$"), @SchemaProperty(name="hash", pattern="^[0-9a-fA-F]{16,64}$")})
@JsonSubTypes(value={@JsonSubTypes.Type(value=Branch.class), @JsonSubTypes.Type(value=Tag.class), @JsonSubTypes.Type(value=Hash.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
public interface Reference
extends Base {
    @NotBlank
    @JsonFormat(pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$")
    public String getName();

    @Nullable
    @JsonFormat(pattern="^[0-9a-fA-F]{16,64}$")
    public String getHash();

    @Value.Check
    default public void checkHash() {
        String hash = this.getHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }
}

