/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.iceberg.BaseTestIceberg;
import java.util.List;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ITTestCatalog
extends BaseTestIceberg {
    private static final String BRANCH = "test-catalog-branch";

    public ITTestCatalog() {
        super(BRANCH);
    }

    @Test
    public void test() {
        this.createTable(TableIdentifier.of((String[])new String[]{"foo", "bar"}));
        List tables = this.catalog.listTables(Namespace.of((String[])new String[]{"foo"}));
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertEquals((Object)"bar", (Object)((TableIdentifier)tables.get(0)).name());
        Assertions.assertEquals((Object)"foo", (Object)((TableIdentifier)tables.get(0)).namespace().toString());
        this.catalog.renameTable(TableIdentifier.of((String[])new String[]{"foo", "bar"}), TableIdentifier.of((String[])new String[]{"foo", "baz"}));
        tables = this.catalog.listTables(null);
        Assertions.assertEquals((int)1, (int)tables.size());
        Assertions.assertEquals((Object)"baz", (Object)((TableIdentifier)tables.get(0)).name());
        Assertions.assertEquals((Object)"foo", (Object)((TableIdentifier)tables.get(0)).namespace().toString());
        this.catalog.dropTable(TableIdentifier.of((String[])new String[]{"foo", "baz"}));
        tables = this.catalog.listTables(Namespace.empty());
        Assertions.assertTrue((boolean)tables.isEmpty());
    }
}

