/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.iceberg.BaseTestIceberg;
import com.dremio.nessie.iceberg.NessieCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ITTestDefaultCatalogBranch
extends BaseTestIceberg {
    public ITTestDefaultCatalogBranch() {
        super("main");
    }

    @Test
    public void testBasicBranch() throws NessieNotFoundException, NessieConflictException {
        TableIdentifier foobar = TableIdentifier.of((String[])new String[]{"foo", "bar"});
        TableIdentifier foobaz = TableIdentifier.of((String[])new String[]{"foo", "baz"});
        this.createTable(foobar, 1);
        this.createTable(foobaz, 1);
        this.catalog.refresh();
        this.tree.createNewBranch("FORWARD", this.catalog.getHash());
        this.hadoopConfig.set("nessie.ref", "FORWARD");
        NessieCatalog forwardCatalog = new NessieCatalog(this.hadoopConfig);
        forwardCatalog.loadTable(foobaz).updateSchema().addColumn("id1", (Type)Types.LongType.get()).commit();
        forwardCatalog.loadTable(foobar).updateSchema().addColumn("id1", (Type)Types.LongType.get()).commit();
        Assertions.assertNotEquals((Object)ITTestDefaultCatalogBranch.getContent(forwardCatalog, foobar), (Object)ITTestDefaultCatalogBranch.getContent(this.catalog, foobar));
        Assertions.assertNotEquals((Object)ITTestDefaultCatalogBranch.getContent(forwardCatalog, foobaz), (Object)ITTestDefaultCatalogBranch.getContent(this.catalog, foobaz));
        System.out.println(ITTestDefaultCatalogBranch.getContent(forwardCatalog, foobar));
        System.out.println(ITTestDefaultCatalogBranch.getContent(this.catalog, foobar));
        forwardCatalog.refresh();
        this.tree.assignBranch("main", this.tree.getReferenceByName("main").getHash(), forwardCatalog.getHash());
        this.catalog.refresh();
        System.out.println(ITTestDefaultCatalogBranch.getContent(forwardCatalog, foobar));
        System.out.println(ITTestDefaultCatalogBranch.getContent(this.catalog, foobar));
        Assertions.assertEquals((Object)ITTestDefaultCatalogBranch.getContent(forwardCatalog, foobar), (Object)ITTestDefaultCatalogBranch.getContent(this.catalog, foobar));
        Assertions.assertEquals((Object)ITTestDefaultCatalogBranch.getContent(forwardCatalog, foobaz), (Object)ITTestDefaultCatalogBranch.getContent(this.catalog, foobaz));
        this.catalog.dropTable(foobar);
        this.catalog.dropTable(foobaz);
        this.tree.deleteBranch("FORWARD", this.tree.getReferenceByName("FORWARD").getHash());
    }
}

